/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.encryptors;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.encryptors.ConcreteEncryptorsFactory;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;

public class EncryptorPropertyValidator
implements Validator {
    private final ConcreteEncryptorsFactory encryptorsFactory;

    public EncryptorPropertyValidator() {
        this((ConcreteEncryptorsFactory)ComponentAccessor.getComponent(ConcreteEncryptorsFactory.class));
    }

    public EncryptorPropertyValidator(ConcreteEncryptorsFactory encryptorsFactory) {
        this.encryptorsFactory = encryptorsFactory;
    }

    @Override
    public Validator.Result validate(String value) {
        if ("DISABLED".equals(value) || this.encryptorsFactory.getAvailableEncryptors().contains(value)) {
            return new Success(value);
        }
        String values = StringUtils.createCommaSeparatedString(this.encryptorsFactory.getAvailableEncryptors());
        return new Failure("Unsupported encryption algorithm key provided. Only the following values are allowed: DISABLED," + values);
    }
}

