/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.encryptors;

import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.db.config.password.ciphers.algorithm.paramters.DecryptionParameters;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingKeyLoggerEncryptor
implements Encryptor {
    private static final String KEY_DIR_PLACEHOLDER = "KEY_DIR";
    private final Logger logger = LoggerFactory.getLogger(MissingKeyLoggerEncryptor.class);
    private final Encryptor delegate;
    private final EncryptionSettings encryptionSettings;

    public MissingKeyLoggerEncryptor(Encryptor delegate, EncryptionSettings encryptionSettings) {
        this.delegate = delegate;
        this.encryptionSettings = encryptionSettings;
    }

    public String encrypt(String password) {
        return this.delegate.encrypt(password);
    }

    public String decrypt(String encryptedPassword) {
        try {
            Gson gson = new Gson();
            DecryptionParameters decryptionParameters = (DecryptionParameters)gson.fromJson(encryptedPassword, DecryptionParameters.class);
            String keyLocation = decryptionParameters.getKeyFilePath().replace(KEY_DIR_PLACEHOLDER, this.encryptionSettings.getKeyFilesDirectoryPath());
            if (!new File(keyLocation).exists()) {
                this.logger.error("Decryption key [{}] is missing. It will prevent connection to your external users directory. Please provide decryption key file or reenter password in user directory setting.", (Object)keyLocation);
            }
        }
        catch (JsonSyntaxException e) {
            this.logger.warn("Cannot check if demanded encryption key exists");
        }
        return this.delegate.decrypt(encryptedPassword);
    }

    public boolean changeEncryptionKey() {
        return this.delegate.changeEncryptionKey();
    }
}

