/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUserCache;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupCache;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.Visitor;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class EagerOfBizUserCache
extends UserOrGroupCache<OfBizUser>
implements OfBizUserCache {
    @VisibleForTesting
    static final CacheSettings USER_CACHE_SETTINGS = new CacheSettingsBuilder().unflushable().replicateViaCopy().build();
    private ClusterLockService clusterLockService;
    private CacheManager cacheManager;
    private DirectoryDao directoryDao;
    private OfBizDelegator ofBizDelegator;

    EagerOfBizUserCache(ClusterLockService clusterLockService, CacheManager cacheManager, DirectoryDao directoryDao, OfBizDelegator ofBizDelegator) {
        super("User");
        this.clusterLockService = clusterLockService;
        this.cacheManager = cacheManager;
        this.directoryDao = directoryDao;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    Cache<DirectoryEntityKey, OfBizUser> createCache() {
        return this.cacheManager.getCache(EagerOfBizUserCache.class.getName() + ".userCache", null, USER_CACHE_SETTINGS);
    }

    @Override
    long countAllUsingDatabase() {
        long count = 0L;
        for (Directory directory : this.directoryDao.findAll()) {
            count += Select.id().from("User").whereEqual("directoryId", directory.getId()).runWith(this.ofBizDelegator).count();
        }
        return count;
    }

    @Override
    public void visitAllUsingDatabase(Visitor<OfBizUser> visitor) {
        Visitor gvVisitor = Functions.mappedVisitor(OfBizUserDao.TO_USER_FUNCTION, visitor);
        for (Directory directory : this.directoryDao.findAll()) {
            Select.columns(OfBizUser.SUPPORTED_FIELDS).from("User").whereEqual("directoryId", directory.getId()).runWith(this.ofBizDelegator).visitWith(gvVisitor);
        }
    }

    @Override
    public List<OfBizUser> getAllCaseInsensitive(long directoryId, Collection<String> userIds) {
        ArrayList<OfBizUser> users = new ArrayList<OfBizUser>(userIds.size());
        for (String userId : userIds) {
            OfBizUser user = (OfBizUser)this.getCaseInsensitive(directoryId, userId);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }
}

