/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz.db;

import com.atlassian.jira.crowd.embedded.ofbiz.db.OfBizTransaction;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import java.util.function.Function;

public class DefaultOfBizTransaction
implements OfBizTransaction {
    private final Transaction transaction;
    private Status status = Status.UNPROCESSED;

    @VisibleForTesting
    DefaultOfBizTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @VisibleForTesting
    static <R> R withTransaction(Function<? super DefaultOfBizTransaction, R> transactionUsingFunction) {
        DefaultOfBizTransaction ofBizTransaction = new DefaultOfBizTransaction(Txn.begin());
        try {
            R result = transactionUsingFunction.apply(ofBizTransaction);
            ofBizTransaction.finish();
            return result;
        }
        catch (Throwable t) {
            try {
                ofBizTransaction.rollback();
            }
            catch (Throwable rbt) {
                t.addSuppressed(rbt);
            }
            throw t;
        }
    }

    static void withTransaction(Consumer<? super DefaultOfBizTransaction> transactionUsingFunction) {
        DefaultOfBizTransaction.withTransaction((? super DefaultOfBizTransaction t) -> {
            transactionUsingFunction.accept((DefaultOfBizTransaction)t);
            return null;
        });
    }

    @VisibleForTesting
    Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isProcessed() {
        return this.status != Status.UNPROCESSED;
    }

    @Override
    public void commit() {
        this.transaction.commit();
        this.status = Status.COMMITTED;
    }

    @Override
    public void rollback() {
        this.transaction.rollback();
        this.status = Status.ROLLED_BACK;
    }

    private void finish() {
        if (!this.isProcessed()) {
            this.commit();
        }
    }

    @VisibleForTesting
    static enum Status {
        UNPROCESSED,
        COMMITTED,
        ROLLED_BACK;

    }
}

