/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.health.ModificationMigrationLocationService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class FileCopyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileCopyService.class);
    private final ModificationMigrationLocationService locationService;

    public FileCopyService(ModificationMigrationLocationService locationService) {
        this.locationService = Objects.requireNonNull(locationService);
    }

    @Nonnull
    public Set<CopyFailure> copyFiles(Collection<Path> relativeFilePaths) {
        return relativeFilePaths.stream().map(this::copyFile).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Optional<CopyFailure> copyFile(Path relativeFilePath) {
        Path from = null;
        Path to = null;
        try {
            from = this.locationService.getCustomisationsDirectory().resolve(relativeFilePath);
            to = this.locationService.getInstallationRootDirectory().resolve(relativeFilePath);
            FileUtils.copyFile((File)from.toFile(), (File)to.toFile());
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error("Failed to copy {} from {} to {}", new Object[]{relativeFilePath, from, to, e});
            return Optional.of(new CopyFailure(e, relativeFilePath));
        }
    }

    public static class CopyFailure {
        private final Error error;
        private final Exception exception;
        private final Path relativeFilePath;

        public CopyFailure(Exception exception, Path relativeFilePath) {
            this.exception = exception;
            this.error = Error.create(exception);
            this.relativeFilePath = relativeFilePath;
        }

        public Error getError() {
            return this.error;
        }

        public Exception getException() {
            return this.exception;
        }

        public Path getRelativeFilePath() {
            return this.relativeFilePath;
        }

        public static enum Error {
            SRC_NOT_FOUND("Source .* does not exist"),
            SRC_IS_DIRECTORY("Source .* exists but is a directory"),
            DEST_IS_DIRECTORY("Destination .* exists but is a directory"),
            SRC_EQ_DEST("Source .* are the same"),
            CANT_CREATE_DEST_DIR("Destination .* directory cannot be created"),
            DEST_READ_ONLY("Destination .* exists but is read-only"),
            SRC_TRUNCATED("Negative size"),
            SRC_CHANGED_SIZE("Failed to copy full contents from"),
            NO_SPACE_ON_DEVICE("No space left on device"),
            OTHER(null);

            private final Pattern pattern;

            @Nullable
            private Error(String regex) {
                this.pattern = regex == null ? null : Pattern.compile(regex);
            }

            public static Error create(Exception exception) {
                String message;
                if (exception instanceof IOException && (message = exception.getMessage()) != null) {
                    for (Error e : Error.values()) {
                        if (e.pattern == null || !e.pattern.matcher(message).find()) continue;
                        return e;
                    }
                }
                return OTHER;
            }
        }
    }
}

