/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.DefaultJiraHome;
import com.atlassian.jira.config.util.JiraHome;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ModificationMigrationLocationService {
    public static final String ORIGINAL_CUSTOMISATION_DIR = "customisations";
    public static final String CUSTOMISATION_DIR = "customisations-backup";
    private final JiraProperties jiraProperties;
    private final JiraHome jiraHome;

    public ModificationMigrationLocationService(JiraProperties jiraProperties, JiraHome jiraHome) {
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
        this.jiraHome = Objects.requireNonNull(jiraHome);
    }

    public static ModificationMigrationLocationService getInstance() {
        return new ModificationMigrationLocationService(JiraSystemProperties.getInstance(), new DefaultJiraHome());
    }

    public Path getOriginalCustomisationsDirectory() {
        return this.getJiraHomeRelativePath(ORIGINAL_CUSTOMISATION_DIR);
    }

    public Path getCustomisationsDirectory() {
        return this.getJiraHomeRelativePath(CUSTOMISATION_DIR);
    }

    private Path getJiraHomeRelativePath(String relativePath) {
        return Optional.ofNullable(this.jiraHome.getLocalHomePath()).map(path -> Paths.get(path, relativePath)).orElseThrow(() -> new IllegalStateException("Could not find jira.home"));
    }

    public Path getInstallationRootDirectory() {
        return this.getTomcatDirectory().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new IllegalStateException("Could not find Tomcat directory."));
    }

    private Optional<String> getTomcatDirectory() {
        return Stream.of("catalina.home", "catalina.base", "working.dir").map(prop -> Optional.ofNullable(this.jiraProperties.getProperty(prop))).filter(Optional::isPresent).findFirst().map(Optional::get);
    }
}

