/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.health.checks.DefaultJiraHomeMessageFactory;
import com.atlassian.jira.health.checks.JiraHomeMessageFactory;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.startup.JiraHomeStartupCheckFailure;
import com.atlassian.jira.util.JiraCollectionUtils;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JiraHomeHealthCheck
extends HealthCheckTemplate {
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/4a4WN");
    private final JiraHomeStartupCheck jiraHomeStartupCheck;
    private final JiraHomeMessageFactory jiraHomeMessageFactory;

    public JiraHomeHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.jiraHomeStartupCheck = JiraHomeStartupCheck.getInstance();
        this.jiraHomeMessageFactory = new DefaultJiraHomeMessageFactory();
    }

    @VisibleForTesting
    JiraHomeHealthCheck(JiraHomeStartupCheck jiraHomeStartupCheck, JiraHomeMessageFactory jiraHomeMessageFactory, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.jiraHomeStartupCheck = Objects.requireNonNull(jiraHomeStartupCheck);
        this.jiraHomeMessageFactory = Objects.requireNonNull(jiraHomeMessageFactory);
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PRE_DATABASE_LAUNCH));
    }

    @Override
    @Nonnull
    protected List<HealthCheckResult> doPerform() {
        return JiraCollectionUtils.listify(this.jiraHomeStartupCheck.getJiraHomeDirectory().leftMap(this::toHealthCheckResult).left().toOptional());
    }

    private HealthCheckResult toHealthCheckResult(JiraHomeStartupCheckFailure jiraHomeStartupCheckFailure) {
        JiraHomeMessageFactory.JiraHomeMessage message = this.jiraHomeMessageFactory.getMessage(jiraHomeStartupCheckFailure);
        Event event = new Event(JohnsonEventType.SETUP.eventType(), message.getHeadline(), message.getMessage().toHtml(), JohnsonEventLevel.FATAL.eventLevel());
        return HealthCheckResult.fail(this, event, KB_URL, jiraHomeStartupCheckFailure.getReason().getAnalyticsValue(), message.getMessage().toText()).get(0);
    }
}

