/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks;

import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformation;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.system.JiraRuntimeInformationFactory;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class MinMemoryHealthCheck
extends HealthCheckTemplate {
    private static final long MEGABYTE = 0x100000L;
    private static final long MIN_XMX = 0x30000000L;
    private static final long MIN_XMS = 0x18000000L;
    private static final String EVENT_DESCRIPTION = "Your memory allocation pool settings need attention";
    private static final String EVENT_BODY = "JIRA runs in a Java virtual machine (JVM), and this JVM is allocated an amount of memory to enable JIRA to run. These amounts can be manually configured.";
    private static final String XMS_WARNING_MESSAGE = "The initial memory allocation pool (-Xms) is recommended to be at least 384m.";
    private static final String XMX_ERROR_MESSAGE = "The maximum memory allocation pool (-Xmx) is required to be at least 786m.";
    private static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/AFgGO");
    private final RuntimeInformation runtimeInformation;

    public MinMemoryHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.runtimeInformation = JiraRuntimeInformationFactory.getRuntimeInformation();
    }

    @VisibleForTesting
    MinMemoryHealthCheck(@Nonnull RuntimeInformation runtimeInformation, HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
        this.runtimeInformation = Objects.requireNonNull(runtimeInformation);
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PRE_DATABASE_LAUNCH));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        return Stream.concat(this.checkMinXms().stream(), this.checkMinXmx().stream()).collect(Collectors.toList());
    }

    private List<HealthCheckResult> checkMinXmx() {
        if (this.runtimeInformation.getXmx() < 0x30000000L) {
            return this.failWith(XMX_ERROR_MESSAGE, JohnsonEventLevel.ERROR.eventLevel());
        }
        return Collections.emptyList();
    }

    private List<HealthCheckResult> checkMinXms() {
        if (this.runtimeInformation.getXms() < 0x18000000L) {
            return this.failWith(XMS_WARNING_MESSAGE, JohnsonEventLevel.WARNING.eventLevel());
        }
        return Collections.emptyList();
    }

    private List<HealthCheckResult> failWith(String errorMessage, EventLevel eventLevel) {
        HealthCheckMessageFormatter message = new HealthCheckMessageFormatter();
        message.append(HealthCheckMessageFormatter.string(EVENT_BODY)).addLineBreak().appendList(HealthCheckMessageFormatter.string(errorMessage));
        Event event = new Event(JohnsonEventType.SETUP.eventType(), EVENT_DESCRIPTION, message.toHtml(), eventLevel);
        if (Objects.equals(eventLevel, JohnsonEventLevel.WARNING.eventLevel())) {
            event.addAttribute((Object)"dismissible", (Object)true);
        }
        return HealthCheckResult.fail(this, event, KB_URL, "minimum-java-memory", message.toText());
    }
}

