/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.checks.database.strategy;

import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.health.checks.database.strategy.VersionPrefixStrategy;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureVersionPrefixStrategy
implements VersionPrefixStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureVersionPrefixStrategy.class);
    private final DatabaseAccessor databaseAccessor;

    public AzureVersionPrefixStrategy(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public String prefix(String version) {
        boolean isAzureDb = (Boolean)this.databaseAccessor.executeQuery(c -> {
            try {
                ResultSet result = c.getJdbcConnection().createStatement().executeQuery("select SERVERPROPERTY ( 'Edition' )");
                if (result.next()) {
                    return Optional.ofNullable(result.getString(1)).map(s -> s.contains("Azure")).orElse(false);
                }
            }
            catch (SQLException e) {
                LOGGER.warn("Couldn't determine MSSQL Edition because of the exception when executing query \"select SERVERPROPERTY ( 'Edition' )\" ", (Throwable)e);
            }
            return false;
        });
        if (isAzureDb) {
            return "Azure " + version;
        }
        return version;
    }
}

