/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.health.web;

import com.atlassian.jira.health.web.JohnsonEventSerializer;
import com.atlassian.jira.health.web.JohnsonTemplateContext;
import com.atlassian.johnson.event.Event;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
class InteractiveJohnsonEventSerializer
implements JohnsonEventSerializer {
    InteractiveJohnsonEventSerializer() {
    }

    @Override
    @Nonnull
    public JsonObject toJSON(Event johnsonEvent) {
        String eventId;
        String urlString;
        URL helpLink;
        Gson gson = new GsonBuilder().create();
        JsonObject eventJSON = new JsonObject();
        eventJSON.addProperty("title", this.getTitle(johnsonEvent));
        this.addNonNullAttribute(eventJSON, "description", this.getDescription(johnsonEvent));
        eventJSON.addProperty("level", this.getLevel(johnsonEvent));
        eventJSON.addProperty("dismissible", this.getDismissible(johnsonEvent));
        JohnsonTemplateContext templateContext = (JohnsonTemplateContext)johnsonEvent.getAttribute((Object)"templateContext");
        if (templateContext != null) {
            eventJSON.add("templateContext", gson.toJsonTree((Object)templateContext));
        }
        if ((helpLink = this.getHelpLink(johnsonEvent)) != null && StringUtils.isNotBlank((CharSequence)(urlString = helpLink.toString()))) {
            eventJSON.addProperty("helpLink", urlString);
        }
        if ((eventId = this.getEventId(johnsonEvent)) != null) {
            eventJSON.addProperty("eventId", eventId);
        }
        return eventJSON;
    }

    private void addNonNullAttribute(JsonObject o, String key, @Nullable String value) {
        if (value != null) {
            o.addProperty(key, value);
        }
    }

    private String getTitle(Event event) {
        String category = event.getKey().getDescription();
        String title = event.getDesc();
        return String.format("%s: %s", category, title);
    }

    private String getDescription(Event event) {
        return event.getException();
    }

    private Boolean getDismissible(Event event) {
        return Boolean.TRUE.equals(event.getAttribute((Object)"dismissible"));
    }

    private String getLevel(Event event) {
        return event.getLevel().getLevel();
    }

    private URL getHelpLink(Event event) {
        return (URL)event.getAttribute((Object)"helpUrl");
    }

    private String getEventId(Event event) {
        return (String)event.getAttribute((Object)"eventKey");
    }
}

