/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import org.apache.commons.lang3.StringUtils;

class ArticleAdjuster {
    private static final String VOWELS = "aeiou";

    ArticleAdjuster() {
    }

    public String getArticle(String currentArticle, String newName) {
        Article article = this.getArticleForWord(newName);
        if (!this.requiresChange(currentArticle, article)) {
            return currentArticle;
        }
        return this.adjustCase(article, currentArticle, newName);
    }

    private boolean requiresChange(String currentArticle, Article article) {
        return !article.toString().equalsIgnoreCase(currentArticle);
    }

    private Article getArticleForWord(String newName) {
        if (this.startsWithVowel(newName)) {
            return Article.AN;
        }
        return Article.A;
    }

    private String adjustCase(Article article, String currentArticle, String capitalizationPattern) {
        String articleStr = article.toString();
        if (this.isUpperCase(currentArticle) && this.isUpperCase(capitalizationPattern)) {
            return articleStr.toUpperCase();
        }
        if (Character.isUpperCase(currentArticle.charAt(0))) {
            return StringUtils.capitalize((String)articleStr.toLowerCase());
        }
        return articleStr.toLowerCase();
    }

    private boolean isUpperCase(String word) {
        return word.toUpperCase().equals(word);
    }

    private boolean startsWithVowel(String word) {
        char firstLetter = Character.toLowerCase(word.charAt(0));
        return VOWELS.indexOf(firstLetter) != -1;
    }

    private static enum Article {
        A,
        AN;

    }
}

