/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project;

import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.MappingResult;
import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.core.ValidationMessage;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.io.IOException;
import java.util.List;
import org.xml.sax.SAXException;

public interface ProjectImportManager {
    public BackupOverview getBackupOverview(String var1, TaskProgressSink var2, I18nHelper var3) throws IOException, SAXException;

    public ProjectImportData getProjectImportData(ProjectImportOptions var1, BackupProject var2, BackupSystemInformation var3, TaskProgressProcessor var4) throws IOException, SAXException;

    public void validateCustomFieldValues(ProjectImportData var1, MappingResult var2, BackupProject var3, TaskProgressProcessor var4, I18nHelper var5) throws IOException, SAXException;

    public void validateFileAttachments(ProjectImportOptions var1, ProjectImportData var2, MappingResult var3, BackupProject var4, BackupSystemInformation var5, TaskProgressProcessor var6, I18nHelper var7) throws IOException, SAXException;

    public void autoMapAndValidateIssueTypes(ProjectImportData var1, MappingResult var2, BackupProject var3, I18nHelper var4);

    public void autoMapAndValidateCustomFields(ProjectImportData var1, MappingResult var2, BackupProject var3, I18nHelper var4);

    public void autoMapCustomFieldOptions(ProjectImportData var1, BackupProject var2);

    public void autoMapProjectRoles(ProjectImportData var1);

    public void autoMapSystemFields(ProjectImportData var1, BackupProject var2);

    public void validateSystemFields(ProjectImportData var1, MappingResult var2, ProjectImportOptions var3, BackupProject var4, TaskProgressInterval var5, I18nHelper var6);

    public List<ValidationMessage> doPluginValidation(BackupProject var1, TaskProgressInterval var2, I18nHelper var3);

    public void importProject(ProjectImportOptions var1, ProjectImportMapper var2, BackupProject var3, ProjectImportResults var4, TaskProgressInterval var5) throws AbortImportException;

    public void doImport(ProjectImportOptions var1, ProjectImportData var2, BackupProject var3, BackupSystemInformation var4, ProjectImportResults var5, TaskProgressInterval var6, I18nHelper var7, ApplicationUser var8) throws IOException, SAXException, IndexException;

    public void createMissingUsers(UserMapper var1, ProjectImportResults var2, TaskProgressInterval var3) throws AbortImportException;
}

