/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeGroup;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.ChangeGroupParser;
import com.atlassian.jira.util.dbc.Null;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ChangeGroupParserImpl
implements ChangeGroupParser {
    private static final String CREATED = "created";
    private static final String AUTHOR = "author";
    private static final String ID = "id";
    private static final String ISSUE = "issue";

    @Override
    public ExternalChangeGroup parse(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String id = (String)attributes.get(ID);
        String issueId = (String)attributes.get(ISSUE);
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new ParseException("A change group must have an id specified.");
        }
        if (StringUtils.isEmpty((CharSequence)issueId)) {
            throw new ParseException("A change group must have an issue id specified.");
        }
        String created = (String)attributes.get(CREATED);
        String author = (String)attributes.get(AUTHOR);
        ExternalChangeGroup changeGroup = new ExternalChangeGroup();
        changeGroup.setId(id);
        changeGroup.setIssueId(issueId);
        changeGroup.setAuthor(author);
        if (created != null) {
            changeGroup.setCreated((Date)Timestamp.valueOf(created));
        }
        return changeGroup;
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalChangeGroup changeGroup) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ID, changeGroup.getId());
        attributes.put(ISSUE, changeGroup.getIssueId());
        attributes.put(AUTHOR, changeGroup.getAuthor());
        if (changeGroup.getCreated() != null) {
            attributes.put(CREATED, new Timestamp(changeGroup.getCreated().getTime()).toString());
        }
        return new EntityRepresentationImpl("ChangeGroup", attributes);
    }
}

