/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.index.IndexFetcher;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import java.io.File;
import java.io.FilenameFilter;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexFetcher
implements IndexFetcher {
    private static final String INDEX_FETCHER = "[INDEX_FETCHER] ";
    static final String MAX_AGE_OF_USABLE_INDEX_SNAPSHOT_IN_HOURS = "com.atlassian.jira.startup.max.age.of.usable.index.snapshot.in.hours";
    private static final int DEFAULT_MAX_USABLE_SNAPSHOT_AGE_IN_DAYS = 8;
    static final int DEFAULT_MAX_USABLE_SNAPSHOT_AGE_IN_HOURS = Math.toIntExact(Duration.ofDays(8L).toHours());
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndexFetcher.class);
    private final FileStores fileStores;
    private final IndexRecoveryManager indexRecoveryManager;
    private final JiraProperties jiraProperties;

    public DefaultIndexFetcher(FileStores fileStores, IndexRecoveryManager indexRecoveryManager, JiraProperties jiraProperties) {
        this.fileStores = fileStores;
        this.indexRecoveryManager = indexRecoveryManager;
        this.jiraProperties = jiraProperties;
    }

    @Override
    public boolean indexSnapshotExistsAndIsFreshEnough() throws IndexException {
        File destinationDir = this.fileStores.getIndexSnapshotsPath().asJavaFile();
        File[] snapshots = this.getSnapshotsSafely(destinationDir);
        if (snapshots != null && snapshots.length > 0) {
            Arrays.sort(snapshots, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            File mostRecentSnapshot = snapshots[0];
            int maxAgeOfIndexSnapshot = this.jiraProperties.getInteger(MAX_AGE_OF_USABLE_INDEX_SNAPSHOT_IN_HOURS, Integer.valueOf(DEFAULT_MAX_USABLE_SNAPSHOT_AGE_IN_HOURS));
            LOG.info("{} Value {} will be used to determine max age of usable snapshot for startup in hours. To modify the value please provide system property: {}. If property is not set default value: {} will be used.", new Object[]{INDEX_FETCHER, maxAgeOfIndexSnapshot, MAX_AGE_OF_USABLE_INDEX_SNAPSHOT_IN_HOURS, DEFAULT_MAX_USABLE_SNAPSHOT_AGE_IN_HOURS});
            Instant fileLastModified = Instant.ofEpochMilli(mostRecentSnapshot.lastModified());
            if (Duration.between(fileLastModified, Instant.now()).toHours() < (long)maxAgeOfIndexSnapshot) {
                LOG.info("{} Fresh enough snapshot: {} exists. Jira will try to use it during startup.", (Object)INDEX_FETCHER, (Object)mostRecentSnapshot.getName());
                return true;
            }
            String snapshotNamesWithTimestamps = Arrays.stream(snapshots).map(f -> "(" + f.getPath() + ", timestamp: " + f.lastModified() + ")").collect(Collectors.joining(", "));
            LOG.info("{} No snapshot younger than {} hours exists among existing snapshots: {}. You can extend the period in which snapshots are considered usable by setting system property: {}.", new Object[]{INDEX_FETCHER, maxAgeOfIndexSnapshot, snapshotNamesWithTimestamps, MAX_AGE_OF_USABLE_INDEX_SNAPSHOT_IN_HOURS});
            return false;
        }
        return false;
    }

    private File[] getSnapshotsSafely(File destinationDir) throws IndexException {
        File[] snapshots;
        try {
            snapshots = destinationDir.listFiles((FilenameFilter)IndexUtils.INDEX_SNAPSHOT_FILTER);
        }
        catch (SecurityException exception) {
            LOG.error("{} Couldn't access index snapshots files: {}", (Object)INDEX_FETCHER, (Object)exception.getMessage());
            throw new IndexException("Couldn't access index snapshots files.", (Exception)exception);
        }
        return snapshots;
    }

    @Override
    public String recoverIndexFromMostRecentSnapshot() throws IndexException {
        IndexCommandResult result;
        File destinationDir = this.fileStores.getIndexSnapshotsPath().asJavaFile();
        File[] snapshots = this.getSnapshotsSafely(destinationDir);
        if (snapshots == null || snapshots.length == 0) {
            throw new IndexException("[INDEX_FETCHER] No snapshots have been found in %s" + destinationDir);
        }
        Arrays.sort(snapshots, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
        File mostRecentSnapshot = snapshots[0];
        String snapshotNamesWithTimestamps = Arrays.stream(snapshots).map(f -> "(" + f.getPath() + ", timestamp: " + f.lastModified() + ")").collect(Collectors.joining(", "));
        int maxAgeOfIndexSnapshot = this.jiraProperties.getInteger(MAX_AGE_OF_USABLE_INDEX_SNAPSHOT_IN_HOURS, Integer.valueOf(DEFAULT_MAX_USABLE_SNAPSHOT_AGE_IN_HOURS));
        LOG.info("{} Jira will try to recover the most recent snapshot: {}, chosen based on \"last modified\" file property from {} existing snapshots: {}. Only snapshots younger than {} hours are considered usable.", new Object[]{INDEX_FETCHER, mostRecentSnapshot.getPath(), snapshots.length, snapshotNamesWithTimestamps, maxAgeOfIndexSnapshot});
        Instant fileLastModified = Instant.ofEpochMilli(mostRecentSnapshot.lastModified());
        if (Duration.between(fileLastModified, Instant.now()).toHours() >= (long)maxAgeOfIndexSnapshot) {
            LOG.warn("{} The most recent index snapshot: {} is older than {} hours. We recommend to take a snapshot every 24 hours.", new Object[]{INDEX_FETCHER, mostRecentSnapshot.getPath(), maxAgeOfIndexSnapshot});
        }
        if (!(result = this.indexRecoveryManager.safeRecoverIndexFromBackup(mostRecentSnapshot, TaskProgressSink.NULL_SINK)).isSuccessful()) {
            throw new IndexException(result.getErrorCollection().getErrorMessages().toString());
        }
        return mostRecentSnapshot.getName();
    }
}

