/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureFlagProvider;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.index.DelayCloseSearcher;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneCorruptionChecker
implements FeatureFlagProvider {
    public static final Logger log = LoggerFactory.getLogger(LuceneCorruptionChecker.class);
    private static final String FIX_INDEX_DURING_STARTUP_DISABLED_FEATURE_FLAG = "com.atlassian.jira.upgrade.startup.fix.index";
    private final FeatureFlag fixIndexDuringStartupFlag;
    private final LuceneDirectoryUtils luceneDirectoryUtils;
    private final FeatureManager featureManager;

    public LuceneCorruptionChecker(LuceneDirectoryUtils luceneDirectoryUtils, FeatureManager featureManager, ClusterInfo clusterInfo) {
        this.luceneDirectoryUtils = luceneDirectoryUtils;
        this.featureManager = featureManager;
        this.fixIndexDuringStartupFlag = FeatureFlag.featureFlag((String)FIX_INDEX_DURING_STARTUP_DISABLED_FEATURE_FLAG).defaultedTo(!clusterInfo.isClustered());
    }

    public void checkAndFixIndexes(Collection<String> allIndexPaths) {
        if (!this.featureManager.isEnabled(this.fixIndexDuringStartupFlag)) {
            log.debug("Index Check during startup is disabled");
            return;
        }
        for (String path : allIndexPaths) {
            if (this.isIndexOpenable(path)) continue;
            this.fixIndex(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isIndexOpenable(String path) {
        File indexDir = new File(path);
        if (!indexDir.exists()) {
            log.info("Index directory doesn't exist for index '{}'", (Object)path);
            return true;
        }
        Directory directory = this.luceneDirectoryUtils.getDirectory(indexDir);
        try (UnmanagedIndexSearcher searcher = new UnmanagedIndexSearcher(new DelayCloseSearcher(new IndexSearcher((IndexReader)DirectoryReader.open((Directory)directory))));){
            searcher.internal().open();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Can't open index '{}'. Reason:", (Object)path, (Object)e);
            return false;
        }
    }

    private void fixIndex(String path) {
        Directory directory = this.luceneDirectoryUtils.getDirectory(new File(path));
        try (LoggingCheckIndex checkIndex = this.getCheckIndex(directory);){
            log.info("Performing detailed check of index '{}'. It may take some time.", (Object)path);
            CheckIndex.Status status = checkIndex.checkIndex();
            if (!status.clean && status.numBadSegments > 0) {
                log.error("Index '{}' is broken: {} bad segments.\n\tPerforming healing the index. {} documents will be lost", new Object[]{path, status.numBadSegments, status.totLoseDocCount});
                checkIndex.fixIndex(status);
            } else {
                log.info("Index '{}' is healthy. Proceeding...", (Object)path);
            }
        }
        catch (Exception e) {
            log.error("Error during checking index health\n\tIndex: {}", (Object)path, (Object)e);
        }
    }

    private LoggingCheckIndex getCheckIndex(Directory directory) throws IOException {
        return new LoggingCheckIndex(new CheckIndex(directory));
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return ImmutableSet.of((Object)this.fixIndexDuringStartupFlag);
    }

    private static class LoggingCheckIndex
    implements Closeable {
        private final CheckIndex checkIndex;
        private final ByteArrayOutputStream outputStream;

        private LoggingCheckIndex(CheckIndex checkIndex) {
            this.checkIndex = checkIndex;
            this.outputStream = new ByteArrayOutputStream();
            checkIndex.setInfoStream(new PrintStream(this.outputStream));
        }

        CheckIndex.Status checkIndex() throws IOException {
            CheckIndex.Status status = this.checkIndex.checkIndex();
            String content = new String(this.outputStream.toByteArray(), StandardCharsets.UTF_8);
            log.debug(content);
            return status;
        }

        void fixIndex(CheckIndex.Status result) throws IOException {
            this.checkIndex.exorciseIndex(result);
        }

        @Override
        public void close() throws IOException {
            this.checkIndex.close();
        }
    }
}

