/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.cluster.dbr.JiraDocumentUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.IndexWriterConfiguration;
import com.atlassian.jira.index.Configuration;
import com.atlassian.jira.index.DefaultIndexEngine;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.MonitoringIndexWriter;
import com.atlassian.jira.index.ReusableIndexSearcher;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.index.WriterWrapperEntityVersionCache;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriterWrapper
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(WriterWrapper.class);
    private final IndexWriter writer;
    private final DefaultIndexEngine.FlushPolicy flushPolicy;
    private final long commitFrequency;
    private final String indexName;
    private final ReusableIndexSearcher indexSearcher;
    final WriterWrapperEntityVersionCache entityVersionCache;

    @Override
    public IndexWriter getLuceneWriter() {
        return this.writer;
    }

    @VisibleForTesting
    WriterWrapper(String indexName, Supplier<IndexWriter> writerFactory, Supplier<UnmanagedIndexSearcher> indexSearcherSupplier, DefaultIndexEngine.FlushPolicy flushPolicy, long commitFrequency) {
        this.indexName = indexName;
        this.indexSearcher = new ReusableIndexSearcher(indexSearcherSupplier);
        this.entityVersionCache = WriterWrapperEntityVersionCache.create(this.getIndexName().orElse(null), this.indexSearcher::close);
        this.writer = (IndexWriter)writerFactory.get();
        this.flushPolicy = flushPolicy;
        this.commitFrequency = commitFrequency;
    }

    WriterWrapper(String indexName, final @Nonnull Configuration configuration, final Index.UpdateMode mode, Supplier<UnmanagedIndexSearcher> indexSearcherSupplier) {
        this(indexName, new Supplier<IndexWriter>(){

            public IndexWriter get() {
                try {
                    IndexWriterConfiguration.WriterSettings writerSettings = configuration.getWriterSettings(mode);
                    IndexWriterConfig luceneConfig = writerSettings.getWriterConfiguration(configuration.getAnalyzer());
                    LuceneDirectoryUtils luceneDirectoryUtils = (LuceneDirectoryUtils)ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
                    luceneConfig.setIndexDeletionPolicy(luceneDirectoryUtils.getDeletionPolicy(configuration.getDirectory()));
                    return MonitoringIndexWriter.create(configuration.getDirectory(), luceneConfig);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }, indexSearcherSupplier, configuration.getWriterSettings(mode).getFlushPolicy(), configuration.getWriterSettings(mode).getCommitFrequency());
    }

    WriterWrapperEntityVersionCache.CacheStats.MutableCacheStats.Result snapshotCacheStats() {
        return this.entityVersionCache.getSnapshotAndReset();
    }

    WriterWrapperEntityVersionCache.CacheStats.MutableCacheStats.Result totalCacheStats() {
        return this.entityVersionCache.getTotal();
    }

    ReusableIndexSearcher.SearcherStats.MutableSearcherStats.Result snapshotSearcherStats() {
        return this.indexSearcher.getSnapshotAndReset();
    }

    ReusableIndexSearcher.SearcherStats.MutableSearcherStats.Result totalSearcherStats() {
        return this.indexSearcher.getTotal();
    }

    @Override
    public void addDocuments(@Nonnull Collection<Document> documents) throws IOException {
        this.entityVersionCache.clear();
        for (Document document : documents) {
            this.writer.addDocument((Iterable)Assertions.notNull((String)"document", (Object)document));
        }
    }

    @Override
    public void deleteDocuments(@Nonnull Term identifyingTerm) throws IOException {
        this.entityVersionCache.clear();
        this.writer.deleteDocuments(new Term[]{(Term)Assertions.notNull((String)"identifyingTerm", (Object)identifyingTerm)});
    }

    @Override
    public void updateDocuments(@Nonnull Term identifyingTerm, @Nonnull Collection<Document> documents) throws IOException {
        this.entityVersionCache.clear();
        this.internalUpdateDocuments(identifyingTerm, documents);
    }

    private void internalUpdateDocuments(@Nonnull Term identifyingTerm, @Nonnull Collection<Document> documents) throws IOException {
        if (documents.size() == 1) {
            this.writer.updateDocument(identifyingTerm, (Iterable)documents.iterator().next());
        } else {
            this.writer.deleteDocuments(new Term[]{identifyingTerm});
            for (Document document : documents) {
                this.writer.addDocument((Iterable)document);
            }
        }
    }

    @Override
    public void updateDocumentConditionally(@Nonnull Term identifyingTerm, @Nonnull Document document, @Nonnull String optimisticLockField) throws IOException {
        this.entityVersionCache.clear();
        BooleanQuery.Builder updateCondition = new BooleanQuery.Builder();
        updateCondition.add(new BooleanClause((Query)new TermQuery(identifyingTerm), BooleanClause.Occur.MUST));
        updateCondition.add(new BooleanClause(LongPoint.newRangeQuery((String)optimisticLockField, (long)0L, (long)document.getField(optimisticLockField).numericValue().longValue()), BooleanClause.Occur.MUST));
        TopDocs topDocs = this.indexSearcher.search((Query)updateCondition.build(), 1);
        if (topDocs.totalHits > 0L) {
            this.writer.updateDocument(identifyingTerm, (Iterable)document);
        }
    }

    String getIndexNameAsString() {
        return this.indexName;
    }

    Optional<IndexDirectoryFactory.Name> getIndexName() {
        if (this.indexName != null) {
            try {
                return Optional.of(IndexDirectoryFactory.Name.valueOf(this.indexName));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public int updateDocumentsWithVersion(@Nonnull Collection<Document> documents) throws IOException, IllegalStateException, IllegalArgumentException {
        IndexDirectoryFactory.Name name = this.getIndexNameOrThrow();
        if (documents.isEmpty()) {
            return 0;
        }
        int countUsingCache = this.updateDocumentsWithVersionUsingCache(name, documents);
        if (countUsingCache >= 0) {
            return countUsingCache;
        }
        int count = 0;
        for (Document document : documents) {
            String documentEntityId = name.getEntityIdFromDocumentOrThrow(document);
            Term identifyingTerm = new Term(name.getEntityIdFieldName(), documentEntityId);
            long documentEntityVersion = name.getEntityVersionFromDocumentOrThrow(document);
            TopDocs topDocs = this.indexSearcher.search((Query)WriterWrapper.updateConditionFindDocumentsWithTermAndVersionGreater(name, identifyingTerm, documentEntityVersion), 1);
            if (topDocs.scoreDocs.length == 0) {
                log.trace("updateDocumentsWithVersion - updating documents in index based on search, entityId: {}, version: {}, searcher: {}, documents.size: {}", new Object[]{documentEntityId, documentEntityVersion, this.indexSearcher.getHashCode(), documents.size()});
                this.writer.updateDocument(identifyingTerm, (Iterable)document);
                this.entityVersionCache.put(documentEntityId, documentEntityVersion);
                ++count;
                continue;
            }
            Long versionFromIndex = this.loadVersionFromIndex(name, topDocs.scoreDocs[0].doc);
            log.trace("updateDocumentsWithVersion - NOT updating documents in index based on search, entityId: {}, version: {}, versionFromIndex: {}, searcher: {}, documents.size: {}", new Object[]{documentEntityId, documentEntityVersion, versionFromIndex, this.indexSearcher.getHashCode(), documents.size()});
            this.entityVersionCache.put(documentEntityId, versionFromIndex);
        }
        return count;
    }

    private Long loadVersionFromIndex(IndexDirectoryFactory.Name name, int docId) throws IOException {
        Document documentWithVersionFromIndex = this.indexSearcher.doc(docId, (Set<String>)ImmutableSet.of((Object)name.getEntityVersionFieldName()));
        return name.getEntityVersionFromDocumentOrThrow(documentWithVersionFromIndex);
    }

    int updateDocumentsWithVersionUsingCache(IndexDirectoryFactory.Name name, Collection<Document> documents) throws IOException {
        long documentEntityVersion;
        String documentEntityId;
        ArrayList<Document> documentsNotOlderThanIndexed = new ArrayList<Document>();
        ArrayList<Document> documentsOlderThanIndexed = new ArrayList<Document>();
        ArrayList<Document> documentsWithUnknownVersion = new ArrayList<Document>();
        for (Document document : documents) {
            documentEntityId = name.getEntityIdFromDocumentOrThrow(document);
            documentEntityVersion = name.getEntityVersionFromDocumentOrThrow(document);
            Optional<Long> versionFromCache = this.entityVersionCache.get(documentEntityId);
            if (versionFromCache.isPresent()) {
                if (documentEntityVersion >= versionFromCache.get()) {
                    documentsNotOlderThanIndexed.add(document);
                    continue;
                }
                documentsOlderThanIndexed.add(document);
                continue;
            }
            documentsWithUnknownVersion.add(document);
        }
        if (log.isTraceEnabled()) {
            log.trace("updateDocumentsWithVersionUsingCache - documents.size: {},allDocumentsFoundInCache: {},documentsNotOlderThanIndexed.size: {}, documentsOlderThanIndexed.size: {}, documentsWithUnknownVersion.size: {}", new Object[]{documents.size(), documentsWithUnknownVersion.isEmpty(), documentsNotOlderThanIndexed.size(), documentsOlderThanIndexed.size(), documentsWithUnknownVersion.size()});
        }
        if (documentsWithUnknownVersion.isEmpty()) {
            for (Document document : documentsNotOlderThanIndexed) {
                documentEntityId = name.getEntityIdFromDocumentOrThrow(document);
                documentEntityVersion = name.getEntityVersionFromDocumentOrThrow(document);
                Term identifyingTerm = new Term(name.getEntityIdFieldName(), documentEntityId);
                this.writer.updateDocument(identifyingTerm, (Iterable)document);
                this.entityVersionCache.put(documentEntityId, documentEntityVersion);
            }
            return documentsNotOlderThanIndexed.size();
        }
        return -1 * documentsWithUnknownVersion.size();
    }

    @Override
    public boolean replaceDocumentsWithVersion(Collection<Document> documents) throws IOException, IllegalStateException, IllegalArgumentException {
        IndexDirectoryFactory.Name name = this.getIndexNameOrThrow();
        if (documents.isEmpty()) {
            return true;
        }
        long documentsMaxVersion = WriterWrapper.getMaxDocumentVersionOrThrow(name, documents);
        String parentEntityIdFieldName = WriterWrapper.getParentEntityIdFieldNameOrThrow(name);
        String parentEntityId = WriterWrapper.getParentEntityIdFieldValueOrThrow(name, documents);
        Term identifyingTerm = new Term(parentEntityIdFieldName, parentEntityId);
        Optional<Long> versionFromCache = this.entityVersionCache.get(parentEntityId);
        if (versionFromCache.isPresent()) {
            if (documentsMaxVersion >= versionFromCache.get()) {
                log.trace("replaceDocumentsWithVersion - replacing documents in index based on cached version, parentEntityId: {}, documentsMaxVersion: {}, versionFromCache: {}, documents.size: {}", new Object[]{parentEntityId, documentsMaxVersion, versionFromCache.get(), documents.size()});
                this.internalUpdateDocuments(identifyingTerm, documents);
                this.entityVersionCache.put(parentEntityId, documentsMaxVersion);
                return true;
            }
            log.trace("replaceDocumentsWithVersion - NOT replacing documents in index based on cached version, parentEntityId: {}, documentsMaxVersion: {}, versionFromCache: {}, documents.size: {}", new Object[]{parentEntityId, documentsMaxVersion, versionFromCache.get(), documents.size()});
            return false;
        }
        TopDocs topDocs = this.indexSearcher.search((Query)WriterWrapper.updateConditionFindDocumentsWithTermAndVersionGreater(name, identifyingTerm, documentsMaxVersion), 1);
        if (topDocs.scoreDocs.length == 0) {
            log.trace("replaceDocumentsWithVersion - replacing documents in index based on search, parentEntityId: {}, documentsMaxVersion: {}, searcher: {}, documents.size: {}", new Object[]{parentEntityId, documentsMaxVersion, this.indexSearcher.getHashCode(), documents.size()});
            this.internalUpdateDocuments(identifyingTerm, documents);
            this.entityVersionCache.put(parentEntityId, documentsMaxVersion);
            return true;
        }
        Long versionFromIndex = this.loadVersionFromIndex(name, topDocs.scoreDocs[0].doc);
        log.trace("replaceDocumentsWithVersion - NOT replacing documents in index based on search, parentEntityId: {}, documentsMaxVersion: {}, versionFromIndex: {}, searcher: {}, documents.size: {}", new Object[]{parentEntityId, documentsMaxVersion, versionFromIndex, this.indexSearcher.getHashCode(), documents.size()});
        this.entityVersionCache.put(parentEntityId, versionFromIndex);
        return false;
    }

    private IndexDirectoryFactory.Name getIndexNameOrThrow() {
        return this.getIndexName().orElseThrow(() -> new IllegalStateException("Writer with name: " + this.indexName + " does not support updating with version. Only the following writers support this functionality: " + Arrays.toString((Object[])IndexDirectoryFactory.Name.values())));
    }

    private static BooleanQuery updateConditionFindDocumentsWithTermAndVersionGreater(IndexDirectoryFactory.Name name, Term identifyingTerm, long version) {
        BooleanQuery.Builder updateCondition = new BooleanQuery.Builder();
        updateCondition.add(new BooleanClause((Query)new TermQuery(identifyingTerm), BooleanClause.Occur.MUST));
        updateCondition.add(new BooleanClause(LongPoint.newRangeQuery((String)name.getEntityVersionFieldName(), (long)(version + 1L), (long)Long.MAX_VALUE), BooleanClause.Occur.MUST));
        return updateCondition.build();
    }

    private static String getParentEntityIdFieldNameOrThrow(IndexDirectoryFactory.Name name) throws IllegalStateException {
        return name.getParentEntityIdFieldName().orElseThrow(() -> new IllegalStateException("Writer with name: " + name.name() + " does not support replacing documents with version. Documents handled by this writer have no parent ID. Only following writers supports this functionality: " + Arrays.stream(IndexDirectoryFactory.Name.values()).filter(indexName -> indexName.getParentEntityIdFieldName().isPresent()).map(Enum::name).collect(Collectors.joining(", "))));
    }

    private static String getParentEntityIdFieldValueOrThrow(IndexDirectoryFactory.Name name, Collection<Document> newDocuments) throws IllegalArgumentException {
        HashSet<String> uniqueParentEntityIdFieldValue = new HashSet<String>(WriterWrapper.getAllParentEntityIdFieldValues(name, newDocuments));
        if (uniqueParentEntityIdFieldValue.size() == 1) {
            return (String)uniqueParentEntityIdFieldValue.iterator().next();
        }
        throw new IllegalArgumentException("Documents with no single unique parent entity id value. All unique parent entity id values found: " + uniqueParentEntityIdFieldValue + " in documents: " + WriterWrapper.toShortString(name, newDocuments));
    }

    private static String toShortString(IndexDirectoryFactory.Name name, Collection<Document> documents) {
        return documents.stream().limit(100L).map(document -> JiraDocumentUtil.documentToShortString(name, document)).collect(Collectors.joining(", "));
    }

    private static List<String> getAllParentEntityIdFieldValues(IndexDirectoryFactory.Name name, Collection<Document> newDocuments) {
        return newDocuments.stream().map(name::getParentEntityIdFromDocument).flatMap(optionalParentEntityId -> optionalParentEntityId.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    private static long getMaxDocumentVersionOrThrow(IndexDirectoryFactory.Name name, Collection<Document> documents) throws IllegalArgumentException {
        return documents.stream().map(name::getEntityVersionFromDocument).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).mapToLong(Long::longValue).max().orElseThrow(() -> new IllegalArgumentException("Documents with no version: " + WriterWrapper.toShortString(name, documents)));
    }

    @Override
    public void optimize() throws IOException {
    }

    @Override
    public void commit() {
        try {
            this.writer.commit();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        this.entityVersionCache.clear();
        try {
            if (DefaultIndexEngine.FlushPolicy.PERIODIC.equals((Object)this.flushPolicy)) {
                this.writer.commit();
            }
            this.writer.close();
        }
        catch (NoSuchFileException noSuchFileException) {
            log.info("Closing index writer with non-existing file. Ignoring: {}", (Object)noSuchFileException.getMessage(), (Object)noSuchFileException);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public DefaultIndexEngine.FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    @Override
    public long getCommitFrequency() {
        return this.commitFrequency;
    }
}

