/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReindexMetadata;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.TemporaryFilesProvider;
import com.atlassian.jira.index.ha.VersionedReplicatedIndexOperation;
import com.atlassian.jira.index.ha.WithIdAndVersion;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultReplicatedIndexManager
implements ReplicatedIndexManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultReplicatedIndexManager.class);
    private final OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore;
    private final TaskManager taskManager;

    public DefaultReplicatedIndexManager(OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore, TaskManager taskManager) {
        this.ofBizReplicatedIndexOperationStore = ofBizReplicatedIndexOperationStore;
        this.taskManager = taskManager;
    }

    @Override
    public void reindexIssues(@Nonnull Collection<? extends WithIdAndVersion> issues) {
        this.reindexEntityWithVersion(issues, AffectedIndex.ISSUE, ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED);
    }

    @Override
    public void reindexComments(Collection<? extends WithIdAndVersion> comments) {
        this.reindexEntityWithVersion(comments, AffectedIndex.COMMENT, ReplicatedIndexOperation.Operation.UPDATE);
    }

    @Override
    public void reindexWorklogs(Collection<? extends WithIdAndVersion> worklogs) {
        this.reindexEntityWithVersion(worklogs, AffectedIndex.WORKLOG, ReplicatedIndexOperation.Operation.UPDATE);
    }

    private void reindexEntityWithVersion(Collection<? extends WithIdAndVersion> entities, AffectedIndex index, ReplicatedIndexOperation.Operation operation) {
        List filtered = entities.stream().filter(this::validForReplication).collect(Collectors.toList());
        if (filtered.size() == 0) {
            log.warn("Could not replicate deindex operation for items in collection: {}, index: {}", entities, (Object)index);
            return;
        }
        try {
            Map<Long, Long> idsToVersions = this.mapIdsToVersions(filtered);
            this.updateReplicatedIndex(idsToVersions, index, SharedEntityType.NONE, operation);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("reindexed " + index));
        }
    }

    @Override
    public void deIndexIssue(WithIdAndVersion issueWithVersion) {
        this.deindexEntityById(issueWithVersion, AffectedIndex.ISSUE);
    }

    @Override
    public void deIndexComment(WithIdAndVersion commentWithVersion) {
        this.deindexEntityById(commentWithVersion, AffectedIndex.COMMENT);
    }

    @Override
    public void deIndexWorklog(WithIdAndVersion worklogWithVersion) {
        this.deindexEntityById(worklogWithVersion, AffectedIndex.WORKLOG);
    }

    private void deindexEntityById(WithIdAndVersion entityToDelete, AffectedIndex affectedIndex) {
        if (!this.validForReplication(entityToDelete)) {
            log.warn("Could not replicate deindex operation for entity: {}, index: {}", (Object)entityToDelete, (Object)affectedIndex);
            return;
        }
        try {
            this.updateReplicatedIndex(Collections.singletonMap(entityToDelete.getId(), entityToDelete.getVersion()), affectedIndex, SharedEntityType.NONE, ReplicatedIndexOperation.Operation.DELETE);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("deindexed " + affectedIndex), (Throwable)e);
        }
    }

    private boolean validForReplication(WithIdAndVersion entityToDelete) {
        return Objects.nonNull(entityToDelete) && Objects.nonNull(entityToDelete.getId()) && Objects.nonNull(entityToDelete.getVersion());
    }

    @Override
    public void reindexProject(Project project) {
        try {
            this.updateReplicatedIndexWithNoVersion((Set<Long>)ImmutableSet.of((Object)project.getId()), AffectedIndex.ISSUE, SharedEntityType.NONE, ReplicatedIndexOperation.Operation.PROJECT_REINDEX);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage(String.format("reindexed project %s (%s)", project.getName(), project.getKey())), (Throwable)e);
        }
    }

    @Override
    public void deIndexProject(Project project) {
        try {
            log.info("Scheduling index snapshot after deindexing project {} ({})", (Object)project.getName(), (Object)project.getKey());
            this.taskManager.submitTask(() -> ((IndexSnapshotOperator)ComponentAccessor.getComponent(IndexSnapshotOperator.class)).performIndexSnapshotBackupAndCleanup(), "Create index snapshot", new IndexSnapshotContext());
            this.updateReplicatedIndexWithNoVersion((Set<Long>)ImmutableSet.of((Object)project.getId()), AffectedIndex.ISSUE, SharedEntityType.NONE, ReplicatedIndexOperation.Operation.PROJECT_DEINDEX);
            log.info("Replicated project deindex operation of project {} ({}) to other nodes ", (Object)project.getName(), (Object)project.getKey());
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage(String.format("deindexed project %s (%s)", project.getName(), project.getKey())), (Throwable)e);
        }
    }

    @Override
    public void indexSharedEntity(SharedEntity entity) {
        try {
            this.updateReplicatedIndexWithNoVersion((Set<Long>)ImmutableSet.of((Object)entity.getId()), AffectedIndex.SHAREDENTITY, SharedEntityType.fromTypeDescriptor((SharedEntity.TypeDescriptor)entity.getEntityType()), ReplicatedIndexOperation.Operation.UPDATE);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("reindexed shared entity"), (Throwable)e);
        }
    }

    @Override
    public void deIndexSharedEntity(SharedEntity entity) {
        try {
            this.updateReplicatedIndexWithNoVersion((Set<Long>)ImmutableSet.of((Object)entity.getId()), AffectedIndex.SHAREDENTITY, SharedEntityType.fromTypeDescriptor((SharedEntity.TypeDescriptor)entity.getEntityType()), ReplicatedIndexOperation.Operation.DELETE);
        }
        catch (Exception e) {
            log.error(this.buildErrorMessage("deindexed shared entity"), (Throwable)e);
        }
    }

    @EventListener
    public void onReindexAllStarted(ReindexAllStartedEvent reindexAllStartedEvent) {
        if (reindexAllStartedEvent.shouldNotifyCluster()) {
            ReplicatedIndexOperation.Operation reindex = reindexAllStartedEvent.isUsingBackgroundIndexing() ? ReplicatedIndexOperation.Operation.BACKGROUND_REINDEX_START : ReplicatedIndexOperation.Operation.FULL_REINDEX_START;
            this.ofBizReplicatedIndexOperationStore.createIndexOperation(AffectedIndex.ALL, SharedEntityType.NONE, reindex, Collections.emptyMap(), "");
        }
    }

    @EventListener
    public void onReindexAllCompleted(ReindexAllCompletedEvent reindexAllCompletedEvent) {
        if (reindexAllCompletedEvent.shouldNotifyCluster()) {
            ReplicatedIndexOperation.Operation reindex = reindexAllCompletedEvent.isUsingBackgroundIndexing() ? ReplicatedIndexOperation.Operation.BACKGROUND_REINDEX_END : ReplicatedIndexOperation.Operation.FULL_REINDEX_END;
            ClusterNodeProperties clusterNodeProperties = (ClusterNodeProperties)ComponentAccessor.getComponent(ClusterNodeProperties.class);
            IndexCopyService indexCopyService = (IndexCopyService)ComponentAccessor.getComponent(IndexCopyService.class);
            String backupFilename = indexCopyService.backupIndex(new ReindexMetadataFilesProvider(reindexAllCompletedEvent.getIndexStartTime()), clusterNodeProperties.getNodeId());
            this.ofBizReplicatedIndexOperationStore.createIndexOperation(AffectedIndex.ALL, SharedEntityType.NONE, reindex, Collections.emptyMap(), backupFilename);
        } else {
            TaskDescriptor taskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
            if (taskDescriptor != null && taskDescriptor.isFinished()) {
                this.taskManager.removeTask(taskDescriptor.getTaskId());
            }
        }
    }

    private void updateReplicatedIndex(Map<Long, Long> affectedIdToVersion, AffectedIndex affectedIndex, SharedEntityType entityType, ReplicatedIndexOperation.Operation operation) {
        Long replicatedIndexOperationId = this.ofBizReplicatedIndexOperationStore.createIndexOperation(affectedIndex, entityType, operation, affectedIdToVersion, "");
        if (replicatedIndexOperationId == null) {
            log.warn("could not create replicated index operation for ids/versions: {}, index: {}, sharedEntity: {}, operation{} ", new Object[]{affectedIdToVersion, affectedIndex, entityType, operation, new Exception()});
        }
    }

    private void updateReplicatedIndexWithNoVersion(Set<Long> affectedIds, AffectedIndex affectedIndex, SharedEntityType entityType, ReplicatedIndexOperation.Operation operation) {
        Optional<IndexDirectoryFactory.Name> indexName = IndexDirectoryFactory.Name.fromSafe(affectedIndex);
        boolean isReplicatedIndexOperationVersioned = indexName.isPresent() && VersionedReplicatedIndexOperation.isReplicatedIndexOperationVersioned(operation, indexName.get());
        Preconditions.checkArgument((!isReplicatedIndexOperationVersioned ? 1 : 0) != 0, (String)"Replication cannot be performed for operation %s on index %s. For indexes %s operations %s must be performed using versioned entity data ", (Object)((Object)operation), (Object)affectedIndex, VersionedReplicatedIndexOperation.VERSIONED_INDEX_NAME, VersionedReplicatedIndexOperation.VERSIONED_OPERATION);
        Long replicatedIndexOperationId = this.ofBizReplicatedIndexOperationStore.createIndexOperationForNonVersionEntities(affectedIndex, entityType, operation, affectedIds, "");
        if (replicatedIndexOperationId == null) {
            log.warn("could not create replicated index operation for ids: {}, index: {}, sharedEntity: {}, operation{} ", new Object[]{affectedIds, affectedIndex, entityType, operation, new Exception()});
        }
    }

    private String buildErrorMessage(String indexOperationInError) {
        return String.format("Caught an exception trying to replicate %s. The replicated index may or may not be correct", indexOperationInError);
    }

    private Map<Long, Long> mapIdsToVersions(Collection<? extends WithIdAndVersion> entities) {
        return entities.stream().filter(idVer -> Objects.nonNull(idVer.getId()) && Objects.nonNull(idVer.getId())).collect(Collectors.toMap(WithId::getId, WithIdAndVersion::getVersion));
    }

    private static class IndexSnapshotContext
    implements TaskContext {
        private IndexSnapshotContext() {
        }

        @Override
        public String buildProgressURL(Long taskId) {
            return null;
        }
    }

    public static class ReindexMetadataFilesProvider
    implements TemporaryFilesProvider {
        private final long replayFromTimestamp;

        public ReindexMetadataFilesProvider(long replayFromTimestamp) {
            this.replayFromTimestamp = replayFromTimestamp;
        }

        @Override
        public Collection<File> writeContribution(File indexDir) throws IOException {
            ReindexMetadata metadata = new ReindexMetadata();
            if (this.replayFromTimestamp >= 0L) {
                metadata.setIndexStartTime(this.replayFromTimestamp);
            }
            return Collections.singleton(metadata.storeTo(indexDir));
        }
    }
}

