/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha.events;

import com.atlassian.analytics.api.annotations.EventName;
import java.time.Duration;

@EventName(value="ha.index.snapshot")
public class IndexSnapshotEvent {
    private final int nodeId;
    private final long uncompressedSize;
    private final long compressedSize;
    private final Duration compressionTime;
    private final Duration totalTime;
    private final String archiver;

    public IndexSnapshotEvent(int nodeId, long uncompressedSize, long compressedSize, Duration compressionTime, Duration totalTime, String archiver) {
        this.nodeId = nodeId;
        this.uncompressedSize = uncompressedSize;
        this.compressedSize = compressedSize;
        this.compressionTime = compressionTime;
        this.totalTime = totalTime;
        this.archiver = archiver;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCompressionTime() {
        return this.compressionTime.toMillis();
    }

    public long getTotalTime() {
        return this.totalTime.toMillis();
    }

    public String getArchiver() {
        return this.archiver;
    }
}

