/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuePropertyClauseValueGenerator
implements ClauseValuesGenerator {
    private static final Logger log = LoggerFactory.getLogger(IssuePropertyClauseValueGenerator.class);
    private final String luceneFieldName;
    private final IssueIndexManager indexManager;

    public IssuePropertyClauseValueGenerator(String luceneFieldName, IssueIndexManager indexManager) {
        this.luceneFieldName = luceneFieldName;
        this.indexManager = indexManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxResults) {
        ImmutableList.Builder builder;
        block3: {
            builder = ImmutableList.builder();
            try {
                BytesRef term;
                BytesRef prefix;
                TermsEnum termsEnum;
                ManagedIndexSearcher indexSearcher = this.indexManager.getIssueSearcher();
                Terms terms = MultiFields.getTerms((IndexReader)indexSearcher.getIndexReader(), (String)this.luceneFieldName);
                if (terms == null || (termsEnum = terms.iterator()).seekCeil(prefix = new BytesRef((CharSequence)valuePrefix)) == TermsEnum.SeekStatus.END) break block3;
                int i = 0;
                while (StringHelper.startsWith((BytesRef)(term = termsEnum.term()), (BytesRef)prefix)) {
                    builder.add((Object)new ClauseValuesGenerator.Result(term.utf8ToString()));
                    if (termsEnum.next() != null && ++i < maxResults) continue;
                    break;
                }
            }
            catch (IOException e) {
                log.error("IOException when getting possible values of the property on the following lucene field name" + this.luceneFieldName, (Throwable)e);
            }
        }
        return new ClauseValuesGenerator.Results((List)builder.build());
    }
}

