/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.stats;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.stats.LongStats;

@EventName(value="jira.search.stats")
@Internal
public class SearchStatsEvent {
    private final IndexDirectoryFactory.Name index;
    private final LongStats searchStatsInMillis;
    private final LongStats docStatsInMillis;
    private final LongStats getSearcherTotalStatsInMillis;
    private final LongStats getNewSearcherStatsInMillis;
    private final long intervalInMillis;

    public SearchStatsEvent(IndexDirectoryFactory.Name index, LongStats searchStatsInMillis, LongStats docStatsInMillis, LongStats getSearcherTotalStatsInMillis, LongStats getNewSearcherStatsInMillis, long intervalInMillis) {
        this.index = index;
        this.searchStatsInMillis = searchStatsInMillis;
        this.docStatsInMillis = docStatsInMillis;
        this.getSearcherTotalStatsInMillis = getSearcherTotalStatsInMillis;
        this.getNewSearcherStatsInMillis = getNewSearcherStatsInMillis;
        this.intervalInMillis = intervalInMillis;
    }

    public IndexDirectoryFactory.Name getIndex() {
        return this.index;
    }

    public long getSearchCount() {
        return this.searchStatsInMillis.count;
    }

    public long getSearchMinMillis() {
        return this.searchStatsInMillis.min;
    }

    public long getSearchMaxMillis() {
        return this.searchStatsInMillis.max;
    }

    public long getSearchAvgMillis() {
        return this.searchStatsInMillis.avg;
    }

    public long getSearchSumMillis() {
        return this.searchStatsInMillis.sum;
    }

    public long getDocCount() {
        return this.docStatsInMillis.count;
    }

    public long getDocMinMillis() {
        return this.docStatsInMillis.min;
    }

    public long getDocMaxMillis() {
        return this.docStatsInMillis.max;
    }

    public long getDocAvgMillis() {
        return this.docStatsInMillis.avg;
    }

    public long getDocSumMillis() {
        return this.docStatsInMillis.sum;
    }

    public long getSearcherTotalCount() {
        return this.getSearcherTotalStatsInMillis.count;
    }

    public long getSearcherTotalMinMillis() {
        return this.getSearcherTotalStatsInMillis.min;
    }

    public long getSearcherTotalMaxMillis() {
        return this.getSearcherTotalStatsInMillis.max;
    }

    public long getSearcherTotalAvgMillis() {
        return this.getSearcherTotalStatsInMillis.avg;
    }

    public long getSearcherTotalSumMillis() {
        return this.getSearcherTotalStatsInMillis.sum;
    }

    public long getSearcherNewCount() {
        return this.getNewSearcherStatsInMillis.count;
    }

    public long getSearcherNewMinMillis() {
        return this.getNewSearcherStatsInMillis.min;
    }

    public long getSearcherNewMaxMillis() {
        return this.getNewSearcherStatsInMillis.max;
    }

    public long getSearcherNewAvgMillis() {
        return this.getNewSearcherStatsInMillis.avg;
    }

    public long getSearcherNewSumMillis() {
        return this.getNewSearcherStatsInMillis.sum;
    }

    public long getIntervalInMillis() {
        return this.intervalInMillis;
    }
}

