/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.monitoring.IpdMonitoringControlService;
import com.atlassian.jira.monitoring.jmx.JmxConfigurationChangedEvent;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.monitoring.jmx.analytics.IpdMonitoringToggledAnalyticsEvent;
import java.util.Objects;
import javax.annotation.Nonnull;

@EventComponent
public class DefaultIpdMonitoringControlService
implements IpdMonitoringControlService {
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final JmxMetricsExposer jmxMetricsExposer;

    public DefaultIpdMonitoringControlService(@Nonnull EventPublisher eventPublisher, @Nonnull FeatureManager featureManager, @Nonnull JmxMetricsExposer jmxMetricsExposer) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.featureManager = Objects.requireNonNull(featureManager, "featureManager");
        this.jmxMetricsExposer = Objects.requireNonNull(jmxMetricsExposer, "jmxMetricsExposer");
    }

    public void setIpdMonitoringEnabled(boolean enabled) {
        if (enabled) {
            if (!this.jmxMetricsExposer.isJmxEnabled()) {
                this.jmxMetricsExposer.startExposing();
            }
            this.enableIpdFeatureFlag();
        } else {
            this.disableIpdFeatureFlag();
        }
        this.eventPublisher.publish((Object)new IpdMonitoringToggledAnalyticsEvent(enabled));
    }

    public boolean isIpdMonitoringEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS);
    }

    @EventListener
    public void onJmxConfigurationChangedEvent(JmxConfigurationChangedEvent jmxConfigurationChangedEvent) {
        if (!jmxConfigurationChangedEvent.isEnabled()) {
            this.disableIpdFeatureFlag();
        }
    }

    private void disableIpdFeatureFlag() {
        this.featureManager.enableSiteDarkFeature(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS.disabledFeatureKey());
    }

    private void enableIpdFeatureFlag() {
        this.featureManager.disableSiteDarkFeature(JiraFeatureFlagRegistrar.IN_PRODUCT_DIAGNOSTICS.disabledFeatureKey());
    }
}

