/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.archiving.query;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.archiving.query.ArchivedState;
import com.atlassian.jira.user.ApplicationUser;
import java.sql.Timestamp;
import java.util.Comparator;

public class ArchivedIssue
implements Comparable<ArchivedIssue> {
    private static final Comparator<ArchivedIssue> ARCHIVED_ISSUE_COMPARATOR = Comparator.comparing(ArchivedIssue::getArchivedDate, Comparator.nullsFirst(Comparator.naturalOrder()));
    private final Issue issue;
    private final ApplicationUser archivedBy;
    private final Timestamp archivedDate;
    private final ArchivedState archivedState;

    ArchivedIssue(Issue issue, ApplicationUser archivedBy, Timestamp archivedDate, ArchivedState archivedState) {
        this.issue = issue;
        this.archivedBy = archivedBy;
        this.archivedDate = archivedDate;
        this.archivedState = archivedState;
    }

    ArchivedIssue(Issue issue) {
        this(issue, issue.getArchivedByUser(), issue.getArchivedDate(), ArchivedState.ISSUE_ARCHIVED);
    }

    public Issue getIssue() {
        return this.issue;
    }

    public ApplicationUser getArchivedBy() {
        return this.archivedBy;
    }

    public Timestamp getArchivedDate() {
        return this.archivedDate;
    }

    public ArchivedState getArchivedState() {
        return this.archivedState;
    }

    @Override
    public int compareTo(ArchivedIssue issue) {
        return ARCHIVED_ISSUE_COMPARATOR.compare(issue, this);
    }
}

