/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistorySplicer;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Window;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class ChangeHistorySearcher {
    private final OfBizDelegator ofBizDelegator;
    private final IssueManager issueManager;
    private final UserManager userManager;
    private final String ENTITY_TYPE_CHANGE_GROUP = "ChangeGroup";

    public ChangeHistorySearcher(OfBizDelegator ofBizDelegator, IssueManager issueManager, UserManager userManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueManager = issueManager;
        this.userManager = userManager;
    }

    public UnboundSearch searchForIssue(@Nonnull Issue issue) {
        return new UnboundSearch(issue.getId());
    }

    private static enum SearchDirection {
        OLDER("desc"),
        NEWER("asc");

        final String sql;

        private SearchDirection(String sql) {
            this.sql = sql;
        }
    }

    public class OngoingSearch {
        private final long issueId;
        private final Optional<Instant> filterByTime;
        private final SearchDirection direction;
        private Optional<Integer> limit = Optional.empty();

        private OngoingSearch(long issueId, Optional<Instant> filterByTime, SearchDirection direction) {
            this.issueId = issueId;
            this.filterByTime = Objects.requireNonNull(filterByTime);
            this.direction = Objects.requireNonNull(direction);
        }

        public OngoingSearch limit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public Window<ChangeHistory> asWindow() {
            if (this.filterByTime.isPresent()) {
                if (this.direction == SearchDirection.NEWER) {
                    return this.searchNewerWindow(this.filterByTime.get());
                }
                return this.searchOlderWindow(this.filterByTime.get());
            }
            return this.searchFromBeginningOrEnd(this.direction);
        }

        private Window<ChangeHistory> searchFromBeginningOrEnd(SearchDirection direction) {
            ChangeHistorySplicer changeHistory;
            Optional<Integer> limitPlusOne = this.limit.map(l -> l + 1);
            List<ChangeHistory> requestedItemsPlusOne = this.searchWithOrderAndLimit(direction, limitPlusOne);
            if (this.limit.isPresent() && requestedItemsPlusOne.size() > this.limit.get()) {
                changeHistory = ChangeHistorySplicer.hideOneAtEnd(requestedItemsPlusOne);
                Optional<Date> dateOfDuplicatedItems = changeHistory.duplicatesFoundAtEnd();
                if (dateOfDuplicatedItems.isPresent()) {
                    List<ChangeHistory> duplicatedItems = this.searchWithDate(dateOfDuplicatedItems.get().toInstant());
                    List<ChangeHistory> afterDuplicatedItems = this.searchFrom(dateOfDuplicatedItems.get().toInstant(), direction, Optional.of(1));
                    changeHistory.appendWithDistinct(duplicatedItems);
                    changeHistory.appendAndHide(afterDuplicatedItems);
                }
            } else {
                changeHistory = ChangeHistorySplicer.hideNothing(requestedItemsPlusOne);
            }
            if (direction == SearchDirection.OLDER) {
                return changeHistory.toWindow().reverse();
            }
            return changeHistory.toWindow();
        }

        private Window<ChangeHistory> searchNewerWindow(Instant time) {
            ChangeHistorySplicer changeHistory;
            Optional<Integer> limitPlusOne = this.limit.map(l -> l + 1);
            List<ChangeHistory> requestedItemsPlusOne = this.searchFrom(time, SearchDirection.NEWER, limitPlusOne);
            List<ChangeHistory> olderThanRequestedItems = this.searchFrom(time, SearchDirection.OLDER, Optional.of(1));
            if (this.limit.isPresent() && requestedItemsPlusOne.size() > this.limit.get()) {
                changeHistory = ChangeHistorySplicer.hideOneAtEnd(requestedItemsPlusOne);
                changeHistory.prependAndHide(olderThanRequestedItems);
                Optional<Date> dateOfDuplicatedItems = changeHistory.duplicatesFoundAtEnd();
                if (dateOfDuplicatedItems.isPresent()) {
                    List<ChangeHistory> duplicatedItems = this.searchWithDate(dateOfDuplicatedItems.get().toInstant());
                    List<ChangeHistory> newerThanDuplicateItems = this.searchFrom(dateOfDuplicatedItems.get().toInstant(), SearchDirection.NEWER, Optional.of(1));
                    changeHistory.appendWithDistinct(duplicatedItems);
                    changeHistory.appendAndHide(newerThanDuplicateItems);
                }
            } else {
                changeHistory = ChangeHistorySplicer.hideNothing(requestedItemsPlusOne);
                changeHistory.prependAndHide(olderThanRequestedItems);
            }
            return changeHistory.toWindow();
        }

        private Window<ChangeHistory> searchOlderWindow(Instant time) {
            ChangeHistorySplicer changeHistory;
            Optional<Integer> limitPlusOne = this.limit.map(l -> l + 1);
            List<ChangeHistory> requestedItemsPlusOne = this.searchFrom(time, SearchDirection.OLDER, limitPlusOne);
            List<ChangeHistory> newerThanRequestedItems = this.searchFrom(time, SearchDirection.NEWER, Optional.of(1));
            if (this.limit.isPresent() && requestedItemsPlusOne.size() > this.limit.get()) {
                changeHistory = ChangeHistorySplicer.hideOneAtStart(requestedItemsPlusOne);
                changeHistory.appendAndHide(newerThanRequestedItems);
                Optional<Date> dateOfDuplicatedItems = changeHistory.duplicatesFoundAtStart();
                if (dateOfDuplicatedItems.isPresent()) {
                    List<ChangeHistory> duplicatedItems = this.searchWithDate(dateOfDuplicatedItems.get().toInstant());
                    List<ChangeHistory> newerThanDuplicatedItems = this.searchFrom(dateOfDuplicatedItems.get().toInstant(), SearchDirection.NEWER, Optional.of(1));
                    changeHistory.prependWithDistinct(duplicatedItems);
                    changeHistory.prependAndHide(newerThanDuplicatedItems);
                }
            } else {
                changeHistory = ChangeHistorySplicer.hideNothing(requestedItemsPlusOne);
                changeHistory.appendAndHide(newerThanRequestedItems);
            }
            return changeHistory.toWindow();
        }

        private List<ChangeHistory> searchWithOrderAndLimit(SearchDirection direction, Optional<Integer> limit) {
            try (OfBizListIterator iterator = ChangeHistorySearcher.this.ofBizDelegator.findListIteratorByCondition("ChangeGroup", (EntityCondition)new EntityExpr("issue", EntityOperator.EQUALS, (Object)this.issueId), null, null, this.orderByClause(direction.sql), this.limitClause(limit));){
                List<ChangeHistory> list = StreamSupport.stream(iterator.spliterator(), false).filter(Objects::nonNull).map(this::toChangeHistory).collect(Collectors.toList());
                return list;
            }
        }

        private List<ChangeHistory> searchWithDate(Instant date) {
            try (OfBizListIterator iterator = ChangeHistorySearcher.this.ofBizDelegator.findListIteratorByCondition("ChangeGroup", (EntityCondition)new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("issue", EntityOperator.EQUALS, (Object)this.issueId), (Object)new EntityExpr("created", EntityOperator.EQUALS, (Object)Timestamp.from(date))), EntityOperator.AND));){
                List<ChangeHistory> list = StreamSupport.stream(iterator.spliterator(), false).filter(Objects::nonNull).map(this::toChangeHistory).collect(Collectors.toList());
                return list;
            }
        }

        private List<ChangeHistory> searchFrom(Instant time, SearchDirection direction, Optional<Integer> limit) {
            EntityOperator operator = direction == SearchDirection.OLDER ? EntityOperator.LESS_THAN : EntityOperator.GREATER_THAN;
            try (OfBizListIterator iterator = ChangeHistorySearcher.this.ofBizDelegator.findListIteratorByCondition("ChangeGroup", (EntityCondition)new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("issue", EntityOperator.EQUALS, (Object)this.issueId), (Object)new EntityExpr("created", operator, (Object)Timestamp.from(time))), EntityOperator.AND), null, null, this.orderByClause(direction.sql), this.limitClause(limit));){
                Stream<ChangeHistory> result = StreamSupport.stream(iterator.spliterator(), false).filter(Objects::nonNull).map(this::toChangeHistory);
                if (direction == SearchDirection.OLDER) {
                    result = result.sorted(Comparator.comparing(ChangeHistory::getTimePerformed));
                }
                List<ChangeHistory> list = result.collect(Collectors.toList());
                return list;
            }
        }

        public List<ChangeHistory> asList() {
            return this.asWindow().get();
        }

        private List<String> orderByClause(String order) {
            return ImmutableList.of((Object)("created " + order), (Object)("id " + order));
        }

        private EntityFindOptions limitClause(Optional<Integer> limit) {
            EntityFindOptions options = EntityFindOptions.findOptions();
            limit.ifPresent(arg_0 -> ((EntityFindOptions)options).setMaxResults(arg_0));
            return options;
        }

        private ChangeHistory toChangeHistory(GenericValue gv) {
            return new ChangeHistory(gv, ChangeHistorySearcher.this.issueManager, ChangeHistorySearcher.this.userManager);
        }
    }

    public class UnboundSearch {
        private final long issueId;

        private UnboundSearch(long issueId) {
            this.issueId = issueId;
        }

        public OngoingSearch since(Instant time) {
            return new OngoingSearch(this.issueId, Optional.of(time), SearchDirection.NEWER);
        }

        public OngoingSearch before(Instant time) {
            return new OngoingSearch(this.issueId, Optional.of(time), SearchDirection.OLDER);
        }

        public OngoingSearch fromBeginning() {
            return new OngoingSearch(this.issueId, Optional.empty(), SearchDirection.NEWER);
        }

        public OngoingSearch fromEnd() {
            return new OngoingSearch(this.issueId, Optional.empty(), SearchDirection.OLDER);
        }
    }
}

