/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.persistence;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;

final class CustomFieldRetrievalHelper {
    private CustomFieldRetrievalHelper() {
    }

    static List<GenericValue> getValuesOrderedByUpdate(OfBizDelegator delegator, Map<String, Object> limitClause) {
        return delegator.findByAnd("CustomFieldValue", limitClause).stream().sorted(CustomFieldUpdatedComparator.INSTANCE).collect(Collectors.toList());
    }

    static enum CustomFieldUpdatedComparator implements Comparator<GenericValue>
    {
        INSTANCE;


        @Override
        public int compare(GenericValue o1, GenericValue o2) {
            int comparisonResult = CustomFieldUpdatedComparator.compare(o1, o2, "updated");
            if (comparisonResult == 0) {
                comparisonResult = CustomFieldUpdatedComparator.compare(o1, o2, "id");
            }
            return comparisonResult;
        }

        private static int compare(GenericValue o1, GenericValue o2, String attribute) {
            Long o2Value;
            Long o1Value = o1 == null ? null : o1.getLong(attribute);
            Long l = o2Value = o2 == null ? null : o2.getLong(attribute);
            if (o1Value != null && o2Value != null) {
                return Long.signum(o1Value - o2Value);
            }
            if (o1Value == null && o2Value == null) {
                return 0;
            }
            if (o1Value == null) {
                return -1;
            }
            return 1;
        }
    }
}

