/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.persistence;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValue;
import com.atlassian.jira.issue.customfields.persistence.OfBizCustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;

@Internal
final class CustomFieldValues {
    private CustomFieldValues() {
    }

    static List<CustomFieldValue> fromOrderedByUpdate(Collection<GenericValue> genericValues) {
        Object nullId = new Object();
        Map<Object, List<GenericValue>> valuesGroupedById = genericValues.stream().collect(Collectors.groupingBy(gv -> MoreObjects.firstNonNull((Object)gv.get("customfield"), (Object)nullId)));
        return valuesGroupedById.values().stream().map(GenericValueBasedCFV::new).collect(Collectors.toList());
    }

    private static class GenericValueBasedCFV
    implements CustomFieldValue {
        private final List<GenericValue> values;

        GenericValueBasedCFV(List<GenericValue> genericValues) {
            this.values = genericValues;
        }

        public String getFieldId() {
            GenericValue gv = this.values.get(0);
            return "customfield_" + gv.get("customfield");
        }

        public List<Object> getValues(PersistenceFieldType persistenceFieldType) {
            return OfBizCustomFieldValuePersister.getValuesFromGenericValues(this.values, persistenceFieldType);
        }

        public List<Object> getValues(PersistenceFieldType persistenceFieldType, String parentKey) {
            Collection gvs = this.values.stream().filter(gv -> Objects.equals(gv.get("parentkey"), parentKey)).collect(Collectors.toList());
            return OfBizCustomFieldValuePersister.getValuesFromGenericValues(gvs, persistenceFieldType);
        }
    }
}

