/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SelectCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldContextValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.SelectCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.customfields.statistics.SelectStatisticsMapper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.SelectCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.MultiClauseDecoratorContextFactory;
import com.atlassian.jira.jql.context.SelectCustomFieldClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.SelectCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.query.ValidatingDecoratorQueryFactory;
import com.atlassian.jira.jql.resolver.CustomFieldOptionResolver;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.jql.validator.SelectCustomFieldValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.CustomFieldOptionsClauseValuesGenerator;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class SelectSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private volatile ClauseNames clauseNames;
    private final ComponentFactory componentFactory;
    private final ComponentLocator componentLocator;
    private CustomFieldInputHelper customFieldInputHelper;

    public SelectSearcher(ComponentFactory componentFactory, ComponentLocator componentLocator) {
        this.componentFactory = componentFactory;
        this.componentLocator = componentLocator;
    }

    public void init(CustomField field) {
        this.clauseNames = field.getClauseNames();
        FieldVisibilityManager fieldVisibilityManager = (FieldVisibilityManager)this.componentLocator.getComponentInstanceOfType(FieldVisibilityManager.class);
        JqlOperandResolver jqlOperandResolver = (JqlOperandResolver)this.componentLocator.getComponentInstanceOfType(JqlOperandResolver.class);
        JqlSelectOptionsUtil jqlSelectOptionsUtil = (JqlSelectOptionsUtil)this.componentLocator.getComponentInstanceOfType(JqlSelectOptionsUtil.class);
        QueryContextConverter queryContextConverter = (QueryContextConverter)this.componentLocator.getComponentInstanceOfType(QueryContextConverter.class);
        this.customFieldInputHelper = (CustomFieldInputHelper)this.componentLocator.getComponentInstanceOfType(CustomFieldInputHelper.class);
        MultiClauseDecoratorContextFactory.Factory multiFactory = (MultiClauseDecoratorContextFactory.Factory)this.componentLocator.getComponentInstanceOfType(MultiClauseDecoratorContextFactory.Factory.class);
        SelectCustomFieldIndexer indexer = new SelectCustomFieldIndexer(fieldVisibilityManager, field);
        OperatorUsageValidator usageValidator = (OperatorUsageValidator)this.componentLocator.getComponentInstanceOfType(OperatorUsageValidator.class);
        CustomFieldOptionResolver customFieldOptionResolver = (CustomFieldOptionResolver)this.componentLocator.getComponentInstanceOfType(CustomFieldOptionResolver.class);
        SelectCustomFieldValueProvider customFieldValueProvider = new SelectCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(this.clauseNames, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, fieldVisibilityManager);
        this.searchInputTransformer = new SelectCustomFieldSearchInputTransformer(field, this.clauseNames, this.searcherInformation.getId(), jqlSelectOptionsUtil, queryContextConverter, jqlOperandResolver, this.customFieldInputHelper);
        Object queryFactory = new SelectCustomFieldClauseQueryFactory(field, jqlSelectOptionsUtil, jqlOperandResolver, customFieldOptionResolver);
        queryFactory = new ValidatingDecoratorQueryFactory(usageValidator, (ClauseQueryFactory)queryFactory);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldContextValueGeneratingClauseHandler((ClauseValidator)this.componentFactory.createObject(SelectCustomFieldValidator.class, field), (ClauseQueryFactory)queryFactory, multiFactory.create((ClauseContextFactory)this.componentFactory.createObject(SelectCustomFieldClauseContextFactory.class, field), false), (ClauseValuesGenerator)this.componentLocator.getComponentInstanceOfType(CustomFieldOptionsClauseValuesGenerator.class), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.OPTION);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        if (this.clauseNames == null) {
            throw new IllegalStateException("Attempt to retrieve Statistics Mapper off uninitialised custom field searcher.");
        }
        SelectConverter selectConverter = (SelectConverter)this.componentLocator.getComponentInstanceOfType(SelectConverter.class);
        return new SelectStatisticsMapper(customField, selectConverter, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper);
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return this.getStatisticsMapper(customField);
    }
}

