/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.customfields.statistics.AbstractCustomFieldStatisticsMapper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldSearchRequestAppender;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class UserPickerStatisticsMapper
extends AbstractCustomFieldStatisticsMapper
implements SearchRequestAppender.Factory {
    private final UserManager userManager;
    private final JiraAuthenticationContext authenticationContext;

    public UserPickerStatisticsMapper(CustomField customField, UserManager userManager, JiraAuthenticationContext authenticationContext) {
        super(customField);
        this.userManager = userManager;
        this.authenticationContext = authenticationContext;
    }

    public Object getValueFromLuceneField(String documentValue) {
        if (StringUtils.isBlank((CharSequence)documentValue)) {
            return null;
        }
        ApplicationUser user = this.userManager.getUserByKey(documentValue);
        return user != null ? user.getDirectoryUser() : null;
    }

    public Comparator getComparator() {
        return new UserCachingComparator(this.getLocale());
    }

    protected String getSearchValue(Object value) {
        return ApplicationUsers.getKeyFor((ApplicationUser)value);
    }

    Locale getLocale() {
        return this.authenticationContext.getLocale();
    }

    public SearchRequestAppender getSearchRequestAppender() {
        return new CustomFieldSearchRequestAppender(this.customField, this);
    }
}

