/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.export.customfield;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportPart;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CsvIssueExporter;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.DefaultCustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportUtils;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.export.customfield.layout.IssueSearchCsvExportLayout;
import com.atlassian.jira.issue.export.customfield.layout.IssueSearchCsvExportLayoutBuilder;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.component.TableLayoutFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCsvIssueExporter
implements CsvIssueExporter {
    private static final Logger log = LoggerFactory.getLogger(DefaultCsvIssueExporter.class);
    protected final JiraAuthenticationContext authenticationContext;
    protected final TableLayoutFactory tableLayoutFactory;
    private final SearchProviderFactory searchProviderFactory;
    private final IssueFactory issueFactory;
    private final SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil;
    private final FeatureManager featureManager;

    public DefaultCsvIssueExporter(JiraAuthenticationContext authenticationContext, TableLayoutFactory tableLayoutFactory, SearchProviderFactory searchProviderFactory, IssueFactory issueFactory, SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil, FeatureManager featureManager) {
        this.authenticationContext = authenticationContext;
        this.tableLayoutFactory = tableLayoutFactory;
        this.searchProviderFactory = searchProviderFactory;
        this.issueFactory = issueFactory;
        this.searchRequestViewBodyWriterUtil = searchRequestViewBodyWriterUtil;
        this.featureManager = featureManager;
    }

    @Override
    public void export(Writer writer, SearchRequest searchRequest, SearchRequestParams searchRequestParams, List<Field> fields) throws IOException, SearchException {
        IssueSearchCsvExportLayout layout = this.getLayout(searchRequest, searchRequestParams, fields);
        this.writeHeader(writer, layout, searchRequest);
        this.writeBody(writer, layout, searchRequest, searchRequestParams);
    }

    private IssueSearchCsvExportLayout getLayout(SearchRequest searchRequest, SearchRequestParams searchRequestParams, List<Field> fields) throws SearchException {
        IssueSearchCsvExportLayoutBuilder builder = new IssueSearchCsvExportLayoutBuilder();
        ManagedIndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        List<Integer> docIds = this.searchRequestViewBodyWriterUtil.searchAndSort(searchRequest, searchRequestParams.getPagerFilter());
        try {
            for (Integer docId : docIds) {
                Document d = searcher.doc(docId.intValue());
                Issue issue = this.issueFactory.getIssue(d);
                for (Field field : fields) {
                    FieldExportParts fieldRepresentation = this.getFieldExportRepresentation(issue, field);
                    if (fieldRepresentation == null) continue;
                    builder.registerFieldRepresentation(field, fieldRepresentation);
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new SearchException("Exception whilst searching for issues " + e.getMessage(), (Exception)e);
        }
    }

    @Nullable
    private FieldExportParts getFieldExportRepresentation(Issue issue, Field field) {
        if (field instanceof ExportableSystemField) {
            return ((ExportableSystemField)field).getRepresentationFromIssue(issue);
        }
        if (field instanceof CustomField) {
            return this.getFieldExportRepresentationForCustomField(issue, (CustomField)field);
        }
        log.warn("Trying to export a field which is not exportable; ignoring", (Object)field);
        return null;
    }

    private FieldExportParts getFieldExportRepresentationForCustomField(Issue issue, CustomField customField) {
        FieldExportParts fieldRepresentation;
        CustomFieldType customFieldType = customField.getCustomFieldType();
        DefaultCustomFieldExportContext context = new DefaultCustomFieldExportContext(customField, this.authenticationContext.getI18nHelper(), "admin.issue.export.field.custom.field");
        if (customFieldType instanceof ExportableCustomFieldType) {
            fieldRepresentation = ((ExportableCustomFieldType)customFieldType).getRepresentationFromIssue(issue, (CustomFieldExportContext)context);
        } else {
            Object value = customFieldType.getValueFromIssue(customField, issue);
            Stream<String> values = value == null ? Stream.of("") : (value instanceof Collection ? ((Collection)value).stream().map(String::valueOf) : Stream.of(value.toString()));
            fieldRepresentation = FieldExportPartsBuilder.buildSinglePartRepresentation((String)customField.getId(), (String)context.getDefaultColumnHeader(), values);
        }
        return fieldRepresentation;
    }

    private void writeHeader(Writer writer, IssueSearchCsvExportLayout layout, SearchRequest searchRequest) throws IOException {
        char delimiter = searchRequest.getCsvDelimiter();
        CsvWriter csv = new CsvWriter(writer, this.featureManager);
        for (IssueSearchCsvExportLayout.FieldLayout field : layout.getFieldLayouts()) {
            for (IssueSearchCsvExportLayout.SubFieldLayout subField : field.getSubFields()) {
                String columnHeader = subField.getColumnHeader();
                Integer i = 0;
                while (i < subField.getColumnCount()) {
                    csv.writeColumn(columnHeader, delimiter);
                    i = i + 1;
                }
            }
        }
        csv.writeRow();
    }

    private void writeBody(Writer writer, IssueSearchCsvExportLayout layout, SearchRequest searchRequest, SearchRequestParams searchRequestParams) throws SearchException {
        char delimiter = searchRequest.getCsvDelimiter();
        CsvWriter csv = new CsvWriter(writer, this.featureManager);
        ManagedIndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        List<Integer> docIds = this.searchRequestViewBodyWriterUtil.searchAndSort(searchRequest, searchRequestParams.getPagerFilter());
        try {
            for (Integer docId : docIds) {
                Document d = searcher.doc(docId.intValue());
                Issue issue = this.issueFactory.getIssue(d);
                for (IssueSearchCsvExportLayout.FieldLayout fieldLayout : layout.getFieldLayouts()) {
                    Field field = fieldLayout.getField();
                    FieldExportParts fieldRepresentation = this.getFieldExportRepresentation(issue, field);
                    if (fieldRepresentation == null) continue;
                    Stream<String> fieldColumns = this.getFieldColumns(fieldRepresentation, fieldLayout);
                    Throwable throwable = null;
                    try {
                        for (String content : fieldColumns::iterator) {
                            csv.writeColumn(content, delimiter);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fieldColumns == null) continue;
                        if (throwable != null) {
                            try {
                                fieldColumns.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fieldColumns.close();
                    }
                }
                csv.writeRow();
            }
        }
        catch (IOException e) {
            throw new SearchException("Exception whilst searching for issues " + e.getMessage(), (Exception)e);
        }
    }

    private Stream<String> getFieldColumns(FieldExportParts fieldExportParts, IssueSearchCsvExportLayout.FieldLayout fieldLayout) {
        Stream<String> ret = Stream.empty();
        for (IssueSearchCsvExportLayout.SubFieldLayout subFieldLayout : fieldLayout.getSubFields()) {
            Integer columnsToPrint = subFieldLayout.getColumnCount();
            Optional possiblePart = fieldExportParts.getPartWithId(subFieldLayout.getFieldItemId());
            Stream partValues = possiblePart.map(FieldExportPart::getValues).orElse(Stream.empty());
            Stream<String> filledPartValues = Stream.concat(partValues, Stream.generate(() -> "")).limit(columnsToPrint.intValue());
            ret = Stream.concat(ret, filledPartValues);
        }
        return ret;
    }

    private static final class CsvWriter {
        private final Writer writer;
        private final FeatureManager featureManager;
        private boolean newLine = true;

        CsvWriter(Writer writer, FeatureManager featureManager) {
            this.writer = writer;
            this.featureManager = featureManager;
        }

        void writeRow() throws IOException {
            this.writer.write("\n");
            this.newLine = true;
        }

        void writeColumn(String content, char delimiter) throws IOException {
            if (this.newLine) {
                this.newLine = false;
            } else {
                this.writer.write(delimiter);
            }
            if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CUSTOM_CSV_ESCAPER)) {
                ExportUtils.CUSTOM_CSV_ESCAPER.translate((CharSequence)content, this.writer);
            } else {
                StringEscapeUtils.ESCAPE_CSV.translate((CharSequence)content, this.writer);
            }
        }
    }
}

