/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.CompositeMap;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.map.Flat3Map;

public class ColumnViewDateTimeHelper {
    private static final String EXCEL_VIEW = "excel_view";
    private static final String EXCEL_VIEW_TEMPLATE = "date-excelview.vm";
    private static final String ISSUE_NAV_TEMPLATE = "date-columnview.vm";
    private final DateTimeFormatter dateTimeFormatter;
    private final JiraAuthenticationContext authenticationContext;

    public ColumnViewDateTimeHelper(DateTimeFormatterFactory dateTimeFormatterFactory, JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.dateTimeFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser();
    }

    String render(NavigableFieldImpl field, FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue, @Nullable Date date) {
        Map<String, Object> legacyVelocityParams = field.getVelocityParams(fieldLayoutItem, this.authenticationContext.getI18nHelper(), displayParams, issue);
        Flat3Map dateVelocityParams = Collections.emptyMap();
        if (date != null) {
            DateTimeStyle displayStyle = displayParams.containsKey(EXCEL_VIEW) ? DateTimeStyle.COMPLETE : DateTimeStyle.DATE;
            dateVelocityParams = new Flat3Map();
            dateVelocityParams.put("title", this.dateTimeFormatter.withStyle(DateTimeStyle.COMPLETE).format(date));
            dateVelocityParams.put("iso8601", this.dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(date));
            dateVelocityParams.put("value", this.dateTimeFormatter.withStyle(displayStyle).format(date));
        }
        return field.renderTemplate(displayParams.containsKey(EXCEL_VIEW) ? EXCEL_VIEW_TEMPLATE : ISSUE_NAV_TEMPLATE, CompositeMap.of(legacyVelocityParams, dateVelocityParams));
    }
}

