/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ColumnLayoutItemImpl
implements ColumnLayoutItem {
    private final NavigableField navigableField;
    private final int position;

    public ColumnLayoutItemImpl(NavigableField navigableField, int position) {
        this.navigableField = navigableField;
        this.position = position;
    }

    public NavigableField getNavigableField() {
        return this.navigableField;
    }

    public String getId() {
        return this.getNavigableField().getId();
    }

    public int getPosition() {
        return this.position;
    }

    public int compareTo(Object o) {
        if (o instanceof ColumnLayoutItem) {
            return this.getPosition() - ((ColumnLayoutItem)o).getPosition();
        }
        throw new IllegalArgumentException(o + " is not of type ColumnLayoutItem.");
    }

    public String getSafeSortOrder(String specifiedSortOrder) {
        if (specifiedSortOrder == null) {
            return this.navigableField.getDefaultSortOrder();
        }
        return specifiedSortOrder;
    }

    public boolean isAliasForField(ApplicationUser user, String jqlName) {
        SearchHandlerManager searchHandlerManager = (SearchHandlerManager)ComponentAccessor.getComponentOfType(SearchHandlerManager.class);
        Collection fieldIds = searchHandlerManager.getFieldIds(user, jqlName);
        return fieldIds.contains(this.navigableField.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnLayoutItemImpl)) {
            return false;
        }
        ColumnLayoutItemImpl columnLayoutItem = (ColumnLayoutItemImpl)o;
        if (this.position != columnLayoutItem.position) {
            return false;
        }
        return !(this.navigableField != null ? !this.navigableField.equals(columnLayoutItem.navigableField) : columnLayoutItem.navigableField != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int result = this.navigableField != null ? this.navigableField.hashCode() : 0;
        result = 29 * result + this.position;
        return result;
    }

    public String getHtml(Map displayParams, Issue issue) {
        FieldLayout fieldLayout = ComponentAccessor.getFieldLayoutManager().getFieldLayout(issue);
        String hiddenFieldId = this.getNavigableField().getHiddenFieldId();
        if (fieldLayout == null || hiddenFieldId != null && fieldLayout.isFieldHidden(hiddenFieldId)) {
            return "";
        }
        String timerName = !ColumnLayoutItemImpl.isProfilingEnabled() ? "" : "Rendering navigable field '" + this.getNavigableField().getId() + "' for issue: " + (issue == null ? "null" : issue.getKey());
        try (Ticker ignored = Timers.start((String)timerName);){
            String string = this.getNavigableField().getColumnViewHtml(fieldLayout.getFieldLayoutItem(this.getNavigableField().getId()), displayParams, issue);
            return string;
        }
    }

    public String getColumnHeadingKey() {
        return this.getNavigableField().getColumnHeadingKey();
    }

    private static boolean isProfilingEnabled() {
        return Timers.getConfiguration().isEnabled();
    }
}

