/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.EditorMarkupParameters;
import com.atlassian.jira.issue.fields.renderer.EditorMarkupService;
import com.atlassian.jira.plugin.renderer.JiraRendererModuleDescriptor;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
@Internal
public class DefaultEditorMarkupService
implements EditorMarkupService {
    private final RendererManager rendererManager;
    private final I18nHelper i18n;

    public DefaultEditorMarkupService(RendererManager rendererManager, I18nHelper i18n) {
        this.rendererManager = rendererManager;
        this.i18n = i18n;
    }

    public ServiceOutcome<String> getEditorMarkupForField(@Nonnull EditorMarkupParameters parameters) {
        ErrorCollection validationResult = this.validateParameters(parameters);
        if (validationResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validationResult);
        }
        JiraRendererModuleDescriptor rendererDescriptor = this.rendererManager.getRendererForType("atlassian-wiki-renderer").getDescriptor();
        Map<Object, Object> defaultParams = this.getDefaultRendererParams();
        String editHTML = rendererDescriptor.getEditVM(parameters.getValue(), parameters.getIssueKey(), "atlassian-wiki-renderer", parameters.getFieldId(), parameters.getFieldName(), defaultParams, false);
        return ServiceOutcomeImpl.ok(editHTML);
    }

    private ErrorCollection validateParameters(EditorMarkupParameters parameters) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (Objects.isNull(parameters) || Objects.isNull(parameters.getFieldId()) || parameters.getFieldId().isEmpty()) {
            errorCollection.addErrorMessage(this.i18n.getText("rest.field.editor.markup.error.invalid.parameters"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return errorCollection;
    }

    private Map<Object, Object> getDefaultRendererParams() {
        return MapBuilder.newBuilder().add((Object)"rows", (Object)"10").add((Object)"cols", (Object)"60").add((Object)"class", (Object)"long-field").toMutableMap();
    }
}

