/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;

public abstract class AbstractFieldScreenLayoutItem
extends AbstractGVBean
implements FieldScreenLayoutItem {
    private final FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;
    protected int position;
    protected String fieldId;
    protected FieldScreenTab fieldScreenTab;

    protected AbstractFieldScreenLayoutItem(FieldScreenManager fieldScreenManager, FieldManager fieldManager) {
        this.fieldScreenManager = fieldScreenManager;
        this.fieldManager = fieldManager;
    }

    public int getPosition() {
        return this.position;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public OrderableField getOrderableField() {
        return this.fieldManager.getOrderableField(this.fieldId);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, new HashMap<String, Object>());
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getCreateHtml(fieldLayoutItem, operationContext, action, issue, new HashMap<String, Object>());
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue) {
        return this.getViewHtml(fieldLayoutItem, operationContext, action, issue, new HashMap<String, Object>());
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map<String, Object> displayParams) {
        if (this.isShown(issue)) {
            return this.getOrderableField().getViewHtml(fieldLayoutItem, action, issue, displayParams);
        }
        return "";
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map<String, Object> displayParams) {
        if (this.isShown(issue)) {
            return this.getOrderableField().getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParams);
        }
        return "";
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map<String, Object> displayParams) {
        if (this.isShown(issue)) {
            return this.getOrderableField().getCreateHtml(fieldLayoutItem, operationContext, action, issue, displayParams);
        }
        return "";
    }

    public boolean isShown(Issue issue) {
        return this.getOrderableField().isShown(issue);
    }

    public FieldScreenTab getFieldScreenTab() {
        return this.fieldScreenTab;
    }

    protected FieldScreenManager getFieldScreenManager() {
        return this.fieldScreenManager;
    }

    protected FieldManager getFieldManager() {
        return this.fieldManager;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldScreenLayoutItem)) {
            return false;
        }
        FieldScreenLayoutItem fieldScreenLayoutItem = (FieldScreenLayoutItem)o;
        if (this.position != fieldScreenLayoutItem.getPosition()) {
            return false;
        }
        if (this.getOrderableField() != null ? !this.getOrderableField().equals(fieldScreenLayoutItem.getOrderableField()) : fieldScreenLayoutItem.getOrderableField() != null) {
            return false;
        }
        return !(this.fieldScreenTab != null ? !this.fieldScreenTab.equals(fieldScreenLayoutItem.getFieldScreenTab()) : fieldScreenLayoutItem.getFieldScreenTab() != null);
    }

    public int hashCode() {
        int result = this.position;
        result = 29 * result + (this.getOrderableField() != null ? this.getOrderableField().hashCode() : 0);
        result = 29 * result + (this.fieldScreenTab != null ? this.fieldScreenTab.hashCode() : 0);
        return result;
    }
}

