/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeScreenSchemeImpl
extends AbstractGVBean
implements IssueTypeScreenScheme {
    private Long id;
    private String name;
    private String description;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private Map<String, IssueTypeScreenSchemeEntity> schemeEntities;

    public IssueTypeScreenSchemeImpl(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        this(issueTypeScreenSchemeManager, null);
    }

    public IssueTypeScreenSchemeImpl(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, GenericValue genericValue) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.setGenericValue(genericValue);
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.name = this.getGenericValue().getString("name");
            this.description = this.getGenericValue().getString("description");
        }
        this.setModified(false);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        if (this.getGenericValue() != null) {
            throw new IllegalStateException("Cannot change id of an existing entity.");
        }
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateGV("name", name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateGV("description", description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        ArrayList<IssueTypeScreenSchemeEntity> schemeEntitiesToStore;
        if (this.isModified()) {
            if (this.getGenericValue() == null) {
                this.issueTypeScreenSchemeManager.createIssueTypeScreenScheme((IssueTypeScreenScheme)this);
            } else {
                this.issueTypeScreenSchemeManager.updateIssueTypeScreenScheme((IssueTypeScreenScheme)this);
                this.setModified(false);
            }
        }
        IssueTypeScreenSchemeImpl issueTypeScreenSchemeImpl = this;
        synchronized (issueTypeScreenSchemeImpl) {
            schemeEntitiesToStore = this.schemeEntities == null ? Collections.emptyList() : new ArrayList<IssueTypeScreenSchemeEntity>(this.schemeEntities.values());
        }
        for (IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity : schemeEntitiesToStore) {
            issueTypeScreenSchemeEntity.store();
        }
    }

    public void remove() {
        if (this.getProjects().size() > 0) {
            throw new IllegalStateException("Cannot delete issue type screen scheme with project attached");
        }
        this.issueTypeScreenSchemeManager.removeIssueTypeSchemeEntities((IssueTypeScreenScheme)this);
        if (this.getGenericValue() != null) {
            this.issueTypeScreenSchemeManager.removeIssueTypeScreenScheme((IssueTypeScreenScheme)this);
        }
    }

    public Collection<IssueTypeScreenSchemeEntity> getEntities() {
        LinkedList<IssueTypeScreenSchemeEntity> entities = new LinkedList<IssueTypeScreenSchemeEntity>(this.getInternalEntities().values());
        Collections.sort(entities);
        return Collections.unmodifiableCollection(entities);
    }

    public IssueTypeScreenSchemeEntity getEntity(String issueTypeId) {
        return this.getInternalEntities().get(issueTypeId);
    }

    @Nonnull
    public FieldScreenScheme getEffectiveFieldScreenScheme(@Nonnull IssueType type) {
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = this.getEntity(type.getId());
        if (issueTypeScreenSchemeEntity == null) {
            issueTypeScreenSchemeEntity = this.getEntity(null);
        }
        return issueTypeScreenSchemeEntity.getFieldScreenScheme();
    }

    public void addEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        issueTypeScreenSchemeEntity.setIssueTypeScreenScheme((IssueTypeScreenScheme)this);
        this.recordEntity(issueTypeScreenSchemeEntity);
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(String issueTypeId) {
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity;
        IssueTypeScreenSchemeImpl issueTypeScreenSchemeImpl = this;
        synchronized (issueTypeScreenSchemeImpl) {
            if (!this.containsEntity(issueTypeId)) {
                return;
            }
            issueTypeScreenSchemeEntity = this.getEntity(issueTypeId);
            this.schemeEntities.remove(issueTypeId);
        }
        if (issueTypeScreenSchemeEntity != null) {
            issueTypeScreenSchemeEntity.remove();
        }
    }

    public boolean containsEntity(String issueTypeId) {
        return this.getInternalEntities().containsKey(issueTypeId);
    }

    public Collection<GenericValue> getProjects() {
        return this.issueTypeScreenSchemeManager.getProjects((IssueTypeScreenScheme)this);
    }

    public boolean isDefault() {
        return DEFAULT_SCHEME_ID.equals(this.getId());
    }

    private synchronized Map<String, IssueTypeScreenSchemeEntity> getInternalEntities() {
        if (this.schemeEntities == null) {
            this.schemeEntities = new HashMap<String, IssueTypeScreenSchemeEntity>();
            for (Object o : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemeEntities((IssueTypeScreenScheme)this)) {
                IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = (IssueTypeScreenSchemeEntity)o;
                this.recordEntity(issueTypeScreenSchemeEntity);
            }
        }
        return Collections.unmodifiableMap(this.schemeEntities);
    }

    private synchronized void recordEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        this.getInternalEntities();
        if (issueTypeScreenSchemeEntity.getIssueTypeId() != null) {
            this.schemeEntities.put(issueTypeScreenSchemeEntity.getIssueTypeId(), issueTypeScreenSchemeEntity);
        } else {
            this.schemeEntities.put(null, issueTypeScreenSchemeEntity);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IssueTypeScreenSchemeImpl)) {
            return false;
        }
        IssueTypeScreenScheme issueTypeScreenScheme = (IssueTypeScreenScheme)o;
        if (this.description != null ? !this.description.equals(issueTypeScreenScheme.getDescription()) : issueTypeScreenScheme.getDescription() != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(issueTypeScreenScheme.getId()) : issueTypeScreenScheme.getId() != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(issueTypeScreenScheme.getName()) : issueTypeScreenScheme.getName() != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

