/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.usage;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QChangeGroup;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QCustomFieldValue;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldUsageDAO {
    public static final int MAX_IDS_IN_UPDATE = 10000;
    private static final Logger log = LoggerFactory.getLogger(CustomFieldUsageDAO.class);
    private final QueryDslAccessor queryDslAccessor;

    public CustomFieldUsageDAO(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
    }

    public Map<String, Timestamp> collectLatestValueUpdatesFromHistory(Collection<String> customFieldNames) {
        List queryResult = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QChangeItem.CHANGE_ITEM.field, QChangeGroup.CHANGE_GROUP.created.max()}).from((Expression)QChangeItem.CHANGE_ITEM)).join((EntityPath)QChangeGroup.CHANGE_GROUP)).on((Predicate)QChangeGroup.CHANGE_GROUP.id.eq(QChangeItem.CHANGE_ITEM.group))).where((Predicate)QChangeItem.CHANGE_ITEM.field.in(customFieldNames))).where((Predicate)QChangeGroup.CHANGE_GROUP.created.isNotNull())).where((Predicate)QChangeGroup.CHANGE_GROUP.id.isNotNull())).where((Predicate)QChangeItem.CHANGE_ITEM.group.isNotNull())).where((Predicate)QChangeItem.CHANGE_ITEM.fieldtype.eq((Object)"custom"))).groupBy((Expression)QChangeItem.CHANGE_ITEM.field)).fetch());
        return queryResult.stream().map(t -> Pair.nicePairOf((Object)t.get((Expression)QChangeItem.CHANGE_ITEM.field), (Object)t.get((Expression)QChangeGroup.CHANGE_GROUP.created.max()))).collect(Collectors.toMap(Pair::first, Pair::second, this.keepFirstValue()));
    }

    public Map<Long, Timestamp> collectLatestValueUpdatesFromIssues(Collection<Long> customFieldIds) {
        List queryResult = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QIssue.ISSUE.created.max(), QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield}).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).join((EntityPath)QIssue.ISSUE)).on((Predicate)QIssue.ISSUE.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.issue))).where((Predicate)QIssue.ISSUE.created.isNotNull())).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.isNotNull())).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield.in(customFieldIds))).groupBy(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield)).fetch());
        return queryResult.stream().map(t -> Pair.of((Object)t.get(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield), (Object)t.get((Expression)QIssue.ISSUE.created.max()))).map(p -> Pair.nicePairOf((Object)p.first(), (Object)p.second())).filter(p -> p.first() != null && p.second() != null).collect(Collectors.toMap(Pair::first, Pair::second, this.keepFirstValue()));
    }

    public Long updateCustomFieldWithLatestValueUpdate(Long cfId, Timestamp timestamp) {
        return this.updateCustomFieldsWithLatestValueUpdate((Set<Long>)ImmutableSet.of((Object)cfId), timestamp);
    }

    public Long updateCustomFieldsWithLatestValueUpdate(Set<Long> customFieldIdsToUpdate, Timestamp updateDate) {
        if (customFieldIdsToUpdate.isEmpty()) {
            return 0L;
        }
        Iterable batches = Iterables.partition(customFieldIdsToUpdate, (int)10000);
        AtomicLong numberOfUpdated = new AtomicLong(0L);
        this.queryDslAccessor.withNewConnection().execute(connection -> {
            int batchNo = 0;
            for (List batch : batches) {
                log.debug("Saving info about recent custom field updates: batch {} containing {} of total {}  custom field ids", new Object[]{batchNo, batch.size(), customFieldIdsToUpdate.size()});
                long rows = numberOfUpdated.addAndGet(connection.update((RelationalPath<?>)QCustomField.CUSTOM_FIELD).set(QCustomField.CUSTOM_FIELD.lastValueUpdate, (Object)updateDate).where((Predicate)QCustomField.CUSTOM_FIELD.id.in((Collection)batch)).where((Predicate)QCustomField.CUSTOM_FIELD.lastValueUpdate.lt((Comparable)updateDate).or((Predicate)QCustomField.CUSTOM_FIELD.lastValueUpdate.isNull())).execute());
                ++batchNo;
            }
        });
        return numberOfUpdated.get();
    }

    public Long updateCustomFieldsWithIssuesWithValueData(Map<Long, Long> customFieldIdsToUpdate) {
        if (customFieldIdsToUpdate.isEmpty()) {
            return 0L;
        }
        AtomicLong totalNumberOfUpdated = new AtomicLong(0L);
        log.debug("Saving number of issues with value info of {} custom fields", (Object)customFieldIdsToUpdate.size());
        this.queryDslAccessor.withNewConnection().execute(connection -> {
            for (Long cfId : customFieldIdsToUpdate.keySet()) {
                long numberOfUpdatedRecords = connection.update((RelationalPath<?>)QCustomField.CUSTOM_FIELD).set(QCustomField.CUSTOM_FIELD.issuesWithValue, customFieldIdsToUpdate.get(cfId)).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)cfId)).execute();
                totalNumberOfUpdated.addAndGet(numberOfUpdatedRecords);
                if (numberOfUpdatedRecords >= 1L) continue;
                log.warn("Could not update number of issues with value info about custom field with id {}", (Object)cfId);
            }
        });
        log.debug("Saved number of issues with value info about {} of requested {} custom fields", (Object)totalNumberOfUpdated.get(), (Object)customFieldIdsToUpdate.size());
        return totalNumberOfUpdated.get();
    }

    public Map<Long, Long> collectIssuesWithValueData(Collection<Long> customFieldIds) {
        log.debug("Collecting numbers of issues with value for {} custom fields", (Object)customFieldIds.size());
        List queryResult = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.countDistinct(), QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield}).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield.in(customFieldIds))).groupBy(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield)).fetch());
        log.debug("Found numbers of issues with value for {} of requested {} custom fields", (Object)queryResult.size(), (Object)customFieldIds.size());
        return queryResult.stream().map(t -> Pair.of((Object)t.get(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield), (Object)t.get((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.countDistinct()))).map(p -> Pair.nicePairOf((Object)p.first(), (Object)p.second())).filter(p -> p.first() != null && p.second() != null).collect(Collectors.toMap(Pair::first, Pair::second, this.keepFirstValue()));
    }

    private <T> BinaryOperator<T> keepFirstValue() {
        return (existing, replacement) -> existing;
    }
}

