/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.cluster.dbr.DBRSender;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingStrategy;
import com.atlassian.jira.index.MultiThreadedIndexingConfiguration;
import com.atlassian.jira.index.MultiThreadedIndexingStrategy;
import com.atlassian.jira.index.Operations;
import com.atlassian.jira.index.RelatedEntityDocumentFactory;
import com.atlassian.jira.index.SimpleIndexingStrategy;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.index.ha.IndexBackupContributionStrategy;
import com.atlassian.jira.index.ha.IndexPerformAndSubpath;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.index.ha.WithIdAndVersion;
import com.atlassian.jira.index.ha.backup.BackupBuilder;
import com.atlassian.jira.index.ha.backup.IndexBackupContributorsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.ChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.CommentDocumentFactory;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexingFeatures;
import com.atlassian.jira.issue.index.IndexingLimitsStats;
import com.atlassian.jira.issue.index.IndexingMode;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.IssueDocumentFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.index.LuceneIssueIndexProvider;
import com.atlassian.jira.issue.index.WorklogDocumentFactory;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.jira.versioning.EntityVersion;
import com.atlassian.jira.versioning.EntityVersioningManager;
import com.atlassian.jira.versioning.IncrementDeletedEntityVersionException;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueIndexer
implements IssueIndexer {
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueIndexer.class);
    private static final Function<Collection<Issue>, Ticker> ISSUES_TICKET_FUNCTION = issues -> IndexingTimers.INDEX_ISSUE_OPERATION_BATCH.start(new String[]{issues.stream().map(Issue::getKey).collect(Collectors.joining(";")), issues.stream().map(Issue::getId).map(Object::toString).collect(Collectors.joining(";"))});
    private final CommentRetriever commentRetriever;
    private final ChangeHistoryRetriever changeHistoryRetriever;
    private final WorklogRetriever worklogRetriever;
    private final MultiThreadedIndexingConfiguration multiThreadedIndexingConfiguration;
    private final LuceneIssueIndexProvider lifecycle;
    private final IssueDocumentFactory issueDocumentFactory;
    private final CommentDocumentFactory commentDocumentFactory;
    private final ChangeHistoryDocumentFactory changeHistoryDocumentFactory;
    private final WorklogDocumentFactory worklogDocumentFactory;
    private final IssueManager issueManager;
    private final IndexBackupContributionStrategy backupPreparationStrategy;
    private final DBRSender dbrSender;
    private final EntityVersioningManager entityVersioningManager;
    private final ReplicatedIndexManager replicatedIndexManager;
    private final IndexingFeatures indexingFeatures;
    private final IndexingLimitsStats indexingLimitsStats;
    private final IndexingStrategy simpleIndexingStrategy = new SimpleIndexingStrategy();
    private final DocumentCreationStrategy documentCreationStrategy = new DefaultDocumentCreationStrategy();

    public DefaultIssueIndexer(@Nonnull IndexDirectoryFactory indexDirectoryFactory, @Nonnull CommentRetriever commentRetriever, @Nonnull ChangeHistoryRetriever changeHistoryRetriever, @Nonnull WorklogRetriever worklogRetriever, @Nonnull ApplicationProperties applicationProperties, @Nonnull IssueDocumentFactory issueDocumentFactory, @Nonnull CommentDocumentFactory commentDocumentFactory, @Nonnull ChangeHistoryDocumentFactory changeHistoryDocumentFactory, @Nonnull WorklogDocumentFactory worklogDocumentFactory, @Nonnull IssueManager issueManager, @Nonnull IndexBackupContributionStrategy backupPreparationStrategy, @Nullable IndexBackupContributorsManager indexBackupContributorsManager, @Nonnull DBRSender dbrSender, @Nonnull EntityVersioningManager entityVersioningManager, @Nonnull ReplicatedIndexManager replicatedIndexManager, @Nonnull IndexingFeatures indexingFeatures, @Nonnull IndexingLimitsStats indexingLimitsStats) {
        this.lifecycle = new LuceneIssueIndexProvider(indexDirectoryFactory);
        this.commentRetriever = (CommentRetriever)Assertions.notNull((String)"commentRetriever", (Object)commentRetriever);
        this.changeHistoryRetriever = (ChangeHistoryRetriever)Assertions.notNull((String)"changeHistoryReriever", (Object)changeHistoryRetriever);
        this.worklogRetriever = (WorklogRetriever)Assertions.notNull((String)"worklogRetriever", (Object)worklogRetriever);
        this.issueDocumentFactory = (IssueDocumentFactory)Assertions.notNull((String)"issueDocumentFactory", (Object)issueDocumentFactory);
        this.commentDocumentFactory = (CommentDocumentFactory)Assertions.notNull((String)"commentDocumentFactory", (Object)commentDocumentFactory);
        this.changeHistoryDocumentFactory = (ChangeHistoryDocumentFactory)Assertions.notNull((String)"changeHistoryDocumentFactory", (Object)changeHistoryDocumentFactory);
        this.worklogDocumentFactory = (WorklogDocumentFactory)Assertions.notNull((String)"worklogDocumentFactory", (Object)worklogDocumentFactory);
        this.issueManager = (IssueManager)Assertions.notNull((String)"issueManager", (Object)issueManager);
        this.multiThreadedIndexingConfiguration = new PropertiesAdapter(applicationProperties);
        this.backupPreparationStrategy = (IndexBackupContributionStrategy)Assertions.notNull((String)"backupPreparationStrategy", (Object)backupPreparationStrategy);
        this.replicatedIndexManager = (ReplicatedIndexManager)Assertions.notNull((String)"replicatedIndexManager", (Object)replicatedIndexManager);
        if (indexBackupContributorsManager != null) {
            indexBackupContributorsManager.registerForBackups(this);
        }
        this.dbrSender = (DBRSender)Assertions.notNull((String)"dbrReplicatorManager", (Object)dbrSender);
        this.entityVersioningManager = (EntityVersioningManager)Assertions.notNull((String)"entityVersioningManager", (Object)entityVersioningManager);
        this.indexingFeatures = (IndexingFeatures)Assertions.notNull((String)"indexingFeatures", (Object)indexingFeatures);
        this.indexingLimitsStats = (IndexingLimitsStats)Assertions.notNull((String)"indexingLimitsStats", (Object)indexingLimitsStats);
    }

    public int getNumberOfIndexingThreads() {
        return this.multiThreadedIndexingConfiguration.noOfThreads();
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result deindexIssues(@Nonnull Collection<? extends WithId> issues, @Nonnull Context context) {
        return this.deindexIssues(issues, context, false);
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result deindexIssues(@Nonnull Collection<? extends WithId> issues, @Nonnull Context context, boolean shouldReplicate) {
        return this.deindexEntities(new DeindexIssueOperation(shouldReplicate), issues);
    }

    private Index.Result deindexEntities(DeindexEntityOperation operation, @Nonnull Collection<? extends WithId> entities) {
        AccumulatingResultBuilder allResults = new AccumulatingResultBuilder();
        IndexDirectoryFactory.Name indexName = operation.getIndexName();
        log.debug("Performing deindexing for {}", (Object)indexName);
        for (WithId withId : entities) {
            if (Objects.isNull(withId) || Objects.isNull(withId.getId())) {
                log.debug("skipping de-indexing for null id");
                continue;
            }
            Long entityId = withId.getId();
            Ticker ignored = IndexingTimers.DEINDEX_ISSUE_OPERATION.start(new Object[]{entityId});
            Throwable throwable = null;
            try {
                Index.Result result = operation.perform(withId);
                allResults.add(indexName.name(), entityId, result);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return allResults.toResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index.Result deIndexProject(Project project, boolean shouldReplicate) {
        try {
            Term projectTerm = this.issueDocumentFactory.getIdentifyingTerm(project);
            Index.Operation delete = Operations.newDelete(projectTerm, Index.UpdateMode.INTERACTIVE);
            AccumulatingResultBuilder results = new AccumulatingResultBuilder();
            results.add("Project", project.getId(), this.lifecycle.getIssueIndex().perform(delete));
            results.add("Comment For Project", project.getId(), this.lifecycle.getCommentIndex().perform(delete));
            results.add("Change History For project", project.getId(), this.lifecycle.getChangeHistoryIndex().perform(delete));
            results.add("Worklog For Project", project.getId(), this.lifecycle.getWorklogIndex().perform(delete));
            Index.Result result = results.toResult();
            return result;
        }
        catch (Exception ex) {
            DefaultIndex.Failure failure = new DefaultIndex.Failure(ex);
            return failure;
        }
        finally {
            if (shouldReplicate) {
                this.replicatedIndexManager.deIndexProject(project);
            }
        }
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result indexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return this.perform(issues, this.simpleIndexingStrategy, context, new IndexIssueOperation(false, false, issueIndexingParams, Index.UpdateMode.INTERACTIVE));
    }

    @Override
    @GuardedBy(value="external index write lock")
    public AccumulatingResultBuilder indexIssuesBatchMode(@Nonnull IssuesBatcher batcher, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return this.doIssuesOperationBatchMode(batcher, context, () -> new IndexIssueOperation(true, false, issueIndexingParams, Index.UpdateMode.BATCH));
    }

    @Override
    @GuardedBy(value="external index write lock")
    public AccumulatingResultBuilder reindexIssuesBatchMode(@Nonnull IssuesBatcher batcher, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return this.doIssuesOperationBatchMode(batcher, context, () -> new ReIndexIssuesOperation(false, issueIndexingParams, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="external index write lock")
    private AccumulatingResultBuilder doIssuesOperationBatchMode(@Nonnull IssuesBatcher batcher, @Nonnull Context context, @Nonnull Supplier<IssuesOperation> operation) {
        AccumulatingResultBuilder resultBuilder = new AccumulatingResultBuilder();
        try {
            this.lifecycle.close();
            this.lifecycle.setMode(IndexingMode.DIRECT);
            for (IssuesIterable batchOfIssues : batcher) {
                resultBuilder.add(this.issuesOperationBatchMode((EnclosedIterable<Issue>)batchOfIssues, context, operation.get()));
            }
            resultBuilder.toResult().await();
        }
        finally {
            this.lifecycle.close();
            this.lifecycle.setMode(IndexingMode.QUEUED);
        }
        return resultBuilder;
    }

    /*
     * Loose catch block
     */
    private <T extends WithId> Index.Result performBatch(EnclosedIterable<T> entities, IndexingStrategy strategy, Context context, EntityOperation<T, ?> operation, int batchSize) {
        try {
            try (Ticker ignored = IndexingTimers.ISSUE_INDEXER_PERFORM_BATCH.start(new String[0]);){
                Assertions.notNull((String)"entities", entities);
                AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
                ArrayList innerBatch = new ArrayList(batchSize);
                entities.foreach(inputEntity -> {
                    if (!operation.shouldSkip(inputEntity)) {
                        innerBatch.add(inputEntity);
                    }
                    if (innerBatch.size() == batchSize) {
                        builder.add(DefaultIssueIndexer.processInnerBatch(context, strategy, operation, new ArrayList(innerBatch)));
                        innerBatch.clear();
                    }
                });
                if (!innerBatch.isEmpty()) {
                    builder.add(DefaultIssueIndexer.processInnerBatch(context, strategy, operation, new ArrayList(innerBatch)));
                    innerBatch.clear();
                }
                Index.Result result = builder.toResult();
                return result;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            strategy.close();
            operation.close();
        }
    }

    private static <T extends WithId> Index.Result processInnerBatch(Context context, IndexingStrategy strategy, EntityOperation<T, ?> operation, List<T> innerBatch) {
        return (Index.Result)strategy.apply(() -> {
            JiraThreadLocalUtils.preCall();
            AccumulatingResultBuilder innerResultsBuilder = new AccumulatingResultBuilder();
            try {
                Map<Boolean, List<WithId>> shouldDeindexGroups = innerBatch.stream().collect(Collectors.partitioningBy(operation::shouldDeindex));
                shouldDeindexGroups.get(true).forEach(operation::deindex);
                Map batch = shouldDeindexGroups.get(false).stream().filter(inputEntity -> DefaultIssueIndexer.safelyBumpVersionIfNeeded(innerResultsBuilder, operation, inputEntity)).map(inputEntity -> DefaultIssueIndexer.reloadEntity(operation, inputEntity)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Function.identity(), arg_0 -> ((Context)context).start(arg_0)));
                innerResultsBuilder.add(operation.perform(batch));
                Index.Result result = innerResultsBuilder.toResult();
                return result;
            }
            finally {
                JiraThreadLocalUtils.postCall();
            }
        });
    }

    private static <T extends WithId> boolean safelyBumpVersionIfNeeded(AccumulatingResultBuilder builder, EntityOperation<T, ?> operation, T inputEntity) {
        try {
            operation.bumpVersionIfNeeded(inputEntity);
            return true;
        }
        catch (IncrementDeletedEntityVersionException e) {
            Long entityId = inputEntity.getId();
            String entityName = operation.getIndexName().name().toLowerCase();
            log.info("The {} with id {} could not be indexed as it is marked as deleted. If you see this message rarely, this is just a result of a race condition between updating and deleting an entity. If this is not the case, the deleted flag can be cleaned on the database:\ndelete from {}_version where {}_id = {} and deleted = 'Y';", new Object[]{entityName, entityId, entityName, entityName, entityId, e});
            builder.add("Entity", inputEntity.getId(), new DefaultIndex.Failure(e));
            return false;
        }
    }

    private static <T extends WithId> Optional<EntityWithVersion<T>> reloadEntity(EntityOperation<T, ?> operation, T inputEntity) {
        Optional<EntityWithVersion<T>> maybeEntity = operation.reload(inputEntity);
        if (!maybeEntity.isPresent()) {
            log.debug("Reloaded entity with id {} from database, but it was null, so it will be skipped", (Object)inputEntity.getId());
        }
        return maybeEntity;
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams, boolean conditionalUpdate, boolean shouldReplicate) {
        return this.perform(issues, this.simpleIndexingStrategy, context, new ReIndexIssuesOperation(shouldReplicate, issueIndexingParams, conditionalUpdate));
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexComments(@Nonnull Collection<Comment> comments, @Nonnull Context context, boolean shouldReplicate) {
        return this.perform(comments, this.simpleIndexingStrategy, context, new CommentOperation(shouldReplicate));
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexWorklogs(@Nonnull Collection<Worklog> worklogs, @Nonnull Context context, boolean shouldReplicate) {
        return this.perform(worklogs, this.simpleIndexingStrategy, context, new WorklogOperation(shouldReplicate));
    }

    @Override
    public Index.Result deindexComments(@Nonnull Collection<? extends WithId> comments, @Nonnull Context context, boolean shouldReplicate) {
        return this.deindexEntities(new DeindexCommentOperation(shouldReplicate), comments);
    }

    @Override
    public Index.Result deindexWorklogs(@Nonnull Collection<? extends WithId> worklogs, @Nonnull Context context, boolean shouldReplicate) {
        return this.deindexEntities(new DeindexWorklogOperation(shouldReplicate), worklogs);
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result conditionalUpdateWithVersion(IndexDirectoryFactory.Name indexName, Document document) {
        Preconditions.checkNotNull((Object)((Object)indexName));
        Preconditions.checkNotNull((Object)document);
        Preconditions.checkState((boolean)indexName.getEntityIdFromDocument(document).isPresent(), (Object)"document with no entity id");
        Preconditions.checkState((boolean)indexName.getEntityVersionFromDocument(document).isPresent(), (Object)"document with no entity version");
        Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
        return this.lifecycle.getIndex(indexName).perform(Operations.newConditionalUpdateWithVersion(document, mode));
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result conditionalUpdateWithVersion(Document issueDocument, Collection<Document> commentDocuments, Collection<Document> changeHistoryDocuments, Collection<Document> worklogDocuments) {
        Index.Operation operation;
        Preconditions.checkNotNull((Object)issueDocument);
        Preconditions.checkNotNull(commentDocuments);
        Preconditions.checkNotNull(changeHistoryDocuments);
        Preconditions.checkNotNull(worklogDocuments);
        Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
        AccumulatingResultBuilder results = new AccumulatingResultBuilder();
        Long issueId = IndexDirectoryFactory.Name.ISSUE.getEntityIdFromDocument(issueDocument).map(Long::valueOf).orElseThrow(() -> new IllegalArgumentException("Issue Document has not entity id"));
        results.add("Issue", issueId, this.conditionalUpdateWithVersion(IndexDirectoryFactory.Name.ISSUE, issueDocument));
        if (!commentDocuments.isEmpty()) {
            operation = Operations.newConditionalUpdateWithVersion(commentDocuments, mode);
            results.add("Comments For Issue", issueId, this.lifecycle.getCommentIndex().perform(operation));
        }
        if (!changeHistoryDocuments.isEmpty()) {
            operation = Operations.newConditionalReplaceCollection(changeHistoryDocuments, mode);
            results.add("Changes For Issue", issueId, this.lifecycle.getChangeHistoryIndex().perform(operation));
        }
        if (!worklogDocuments.isEmpty()) {
            operation = Operations.newConditionalUpdateWithVersion(worklogDocuments, mode);
            results.add("Worklogs For Issue", issueId, this.lifecycle.getWorklogIndex().perform(operation));
        }
        return results.toResult();
    }

    @Override
    public void deleteIndexes() {
        for (Index.Manager manager : this.lifecycle) {
            manager.deleteIndexDirectory();
        }
    }

    @Override
    public void deleteIndexes(@Nonnull IssueIndexingParams issueIndexingParams) {
        Set<IndexDirectoryFactory.Name> indexes = this.transformIndexingParamsToIndexesEnumSet(issueIndexingParams);
        for (IndexDirectoryFactory.Name indexName : indexes) {
            this.lifecycle.get(indexName).deleteIndexDirectory();
        }
    }

    @Override
    public UnmanagedIndexSearcher openEntitySearcher(IndexDirectoryFactory.Name index) {
        return this.lifecycle.get(index).openSearcher();
    }

    @Override
    public Index.Result optimize() {
        AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
        for (Index.Manager manager : this.lifecycle) {
            builder.add(manager.getIndex().perform(Operations.newOptimize()));
        }
        return builder.toResult();
    }

    @Override
    public void shutdown() {
        this.lifecycle.close();
    }

    @Override
    public List<String> getIndexPaths() {
        return this.lifecycle.getIndexPaths();
    }

    @Override
    public String getIndexRootPath() {
        return this.lifecycle.getIndexRootPath();
    }

    /*
     * Loose catch block
     */
    private <T extends WithId> Index.Result perform(EnclosedIterable<T> entities, IndexingStrategy strategy, Context context, EntityOperation<T, ?> operation) {
        try {
            try (Ticker ignored = IndexingTimers.ISSUE_INDEXER_PERFORM.start(new String[0]);){
                Assertions.notNull((String)"entities", entities);
                AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
                entities.foreach(inputEntity -> {
                    if (inputEntity == null) {
                        log.debug("Asked to index a null entity .... Skip!");
                        return;
                    }
                    if (operation.shouldSkip(inputEntity)) {
                        return;
                    }
                    if (operation.shouldDeindex(inputEntity)) {
                        operation.deindex(inputEntity);
                        return;
                    }
                    try {
                        operation.bumpVersionIfNeeded(inputEntity);
                        Optional<EntityWithVersion<WithId>> maybeEntity = operation.reload(inputEntity);
                        if (!maybeEntity.isPresent()) {
                            log.debug("Reloaded entity with id {} from database, but it was null, so it will be skipped", (Object)inputEntity.getId());
                            return;
                        }
                        EntityWithVersion<WithId> entity = maybeEntity.get();
                        Context.Task task = context.start(entity);
                        Index.Result result = (Index.Result)strategy.apply(() -> operation.perform(entity, task));
                        builder.add("Entity", entity.getId(), result);
                    }
                    catch (IncrementDeletedEntityVersionException e) {
                        Long entityId = inputEntity.getId();
                        String entityName = operation.getIndexName().name().toLowerCase();
                        log.info("The {} with id {} could not be indexed as it is marked as deleted. If you see this message rarely, this is just a result of a race condition between updating and deleting an entity. If this is not the case, the deleted flag can be cleaned on the database:\ndelete from {}_version where {}_id = {} and deleted = 'Y';", new Object[]{entityName, entityId, entityName, entityName, entityId, e});
                        builder.add("Entity", inputEntity.getId(), new DefaultIndex.Failure(e));
                    }
                });
                Index.Result result = builder.toResult();
                return result;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            strategy.close();
            operation.close();
        }
    }

    @GuardedBy(value="external index write lock")
    private Index.Result issuesOperationBatchMode(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssuesOperation operation) {
        MultiThreadedIndexingStrategy strategy = new MultiThreadedIndexingStrategy(this.simpleIndexingStrategy, this.multiThreadedIndexingConfiguration, "IssueIndexer");
        int batchSize = this.indexingFeatures.getCustomFieldIndexingBatchSize();
        if (batchSize > 1) {
            return this.performBatch(issues, strategy, context, operation, batchSize);
        }
        return this.perform(issues, (IndexingStrategy)strategy, context, operation);
    }

    private <T extends WithId> Index.Result perform(Iterable<T> entities, IndexingStrategy strategy, Context context, EntityOperation<T, ?> operation) {
        return this.perform(CollectionEnclosedIterable.from((Collection)Lists.newArrayList(entities)), strategy, context, operation);
    }

    @Override
    public void contributeToBackup(BackupBuilder backupBuilder) {
        ArrayList<IndexPerformAndSubpath> indexes = new ArrayList<IndexPerformAndSubpath>();
        indexes.add(new IndexPerformAndSubpath(this.lifecycle.get(IndexDirectoryFactory.Name.ISSUE).getIndex()::perform, Paths.get("issues", new String[0])));
        indexes.add(new IndexPerformAndSubpath(this.lifecycle.get(IndexDirectoryFactory.Name.WORKLOG).getIndex()::perform, Paths.get("worklogs", new String[0])));
        indexes.add(new IndexPerformAndSubpath(this.lifecycle.get(IndexDirectoryFactory.Name.COMMENT).getIndex()::perform, Paths.get("comments", new String[0])));
        indexes.add(new IndexPerformAndSubpath(this.lifecycle.get(IndexDirectoryFactory.Name.CHANGE_HISTORY).getIndex()::perform, Paths.get("changes", new String[0])));
        log.info("IssueIndexer starts adding {} indexes to backup from: {}", (Object)indexes.size(), indexes);
        this.backupPreparationStrategy.addToBackup(backupBuilder, indexes);
        log.info("IssueIndexer done adding {} indexes to backup from: {}", (Object)indexes.size(), indexes);
    }

    private Set<IndexDirectoryFactory.Name> transformIndexingParamsToIndexesEnumSet(@Nonnull IssueIndexingParams issueIndexingParams) {
        EnumSet<IndexDirectoryFactory.Name> indexes = EnumSet.noneOf(IndexDirectoryFactory.Name.class);
        if (issueIndexingParams.isIndexIssues()) {
            indexes.add(IndexDirectoryFactory.Name.ISSUE);
        }
        if (issueIndexingParams.isIndexComments()) {
            indexes.add(IndexDirectoryFactory.Name.COMMENT);
        }
        if (issueIndexingParams.isIndexChangeHistory()) {
            indexes.add(IndexDirectoryFactory.Name.CHANGE_HISTORY);
        }
        if (issueIndexingParams.isIndexWorklogs()) {
            indexes.add(IndexDirectoryFactory.Name.WORKLOG);
        }
        return indexes;
    }

    static class PropertiesAdapter
    implements MultiThreadedIndexingConfiguration {
        private final ApplicationProperties applicationProperties;

        PropertiesAdapter(ApplicationProperties applicationProperties) {
            this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        }

        @Override
        public int minimumBatchSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.minbatchsize", (int)50);
        }

        @Override
        public int maximumQueueSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.maxqueuesize", (int)4000);
        }

        @Override
        public int noOfThreads() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.threads", (int)20);
        }
    }

    class DefaultDocumentCreationStrategy
    implements DocumentCreationStrategy {
        DefaultDocumentCreationStrategy() {
        }

        @Override
        public Documents get(EntityWithVersion<Issue> issueWithVersion, IssueIndexingParams issueIndexingParams) {
            DocumentBuilder commentDocumentBuilder = this.getDocumentBuilder(DefaultIssueIndexer.this.commentRetriever, DefaultIssueIndexer.this.commentDocumentFactory);
            DocumentBuilder changeHistoryDocumentBuilder = this.getDocumentBuilder(DefaultIssueIndexer.this.changeHistoryRetriever, DefaultIssueIndexer.this.changeHistoryDocumentFactory);
            DocumentBuilder worklogDocumentBuilder = this.getDocumentBuilder(DefaultIssueIndexer.this.worklogRetriever, DefaultIssueIndexer.this.worklogDocumentFactory);
            DefaultIssueIndexer.this.indexingLimitsStats.indexWithRelated(issueIndexingParams);
            List<Optional<Document>> comments = issueIndexingParams.isIndexComments() ? commentDocumentBuilder.buildDocuments(issueWithVersion) : Collections.emptyList();
            List<Optional<Document>> changes = issueIndexingParams.isIndexChangeHistory() ? changeHistoryDocumentBuilder.buildDocuments(issueWithVersion) : Collections.emptyList();
            List<Optional<Document>> worklogs = issueIndexingParams.isIndexWorklogs() ? worklogDocumentBuilder.buildDocuments(issueWithVersion) : Collections.emptyList();
            Optional<Document> issues = DefaultIssueIndexer.this.issueDocumentFactory.createDocument(issueWithVersion);
            return new Documents(issueWithVersion.getEntity(), issues, comments, changes, worklogs);
        }

        private <T extends WithId> DocumentBuilder getDocumentBuilder(EntityRetriever<T> retriever, EntityDocumentFactory<T> documentFactory) {
            return issueWithVersion -> retriever.retrieve(issueWithVersion).stream().map(documentFactory::createDocument).collect(Collectors.toList());
        }

        @Override
        public Map<EntityWithVersion<Issue>, Optional<Documents>> get(List<EntityWithVersion<Issue>> issuesWithVersion, IssueIndexingParams issueIndexingParams) {
            HashMap comments = new HashMap();
            HashMap changes = new HashMap();
            HashMap worklogs = new HashMap();
            issuesWithVersion.forEach(issueWithVersion -> {
                comments.put(issueWithVersion, issueIndexingParams.isIndexComments() ? DefaultIssueIndexer.this.commentDocumentFactory.createDocuments(DefaultIssueIndexer.this.commentRetriever.retrieve((EntityWithVersion<Issue>)issueWithVersion)).values() : Collections.emptySet());
                changes.put(issueWithVersion, issueIndexingParams.isIndexChangeHistory() ? DefaultIssueIndexer.this.changeHistoryDocumentFactory.createDocuments(DefaultIssueIndexer.this.changeHistoryRetriever.retrieve((EntityWithVersion<Issue>)issueWithVersion)).values() : Collections.emptySet());
                worklogs.put(issueWithVersion, issueIndexingParams.isIndexWorklogs() ? DefaultIssueIndexer.this.worklogDocumentFactory.createDocuments(DefaultIssueIndexer.this.worklogRetriever.retrieve((EntityWithVersion<Issue>)issueWithVersion)).values() : Collections.emptySet());
            });
            Map issues = DefaultIssueIndexer.this.issueDocumentFactory.createDocuments(issuesWithVersion);
            return issues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.of(new Documents((Issue)((EntityWithVersion)entry.getKey()).getEntity(), (Optional)entry.getValue(), (Collection)comments.get(entry.getKey()), (Collection)changes.get(entry.getKey()), (Collection)worklogs.get(entry.getKey())))));
        }
    }

    @FunctionalInterface
    static interface DocumentBuilder {
        public Collection<Optional<Document>> buildDocuments(EntityWithVersion<Issue> var1);
    }

    public class Documents {
        private final Document issueDocument;
        private final List<Document> comments;
        private final List<Document> changes;
        private final List<Document> worklogs;
        private final Term term;

        Documents(Issue issue, Optional<Document> issueDocument, Collection<Optional<Document>> comments, Collection<Optional<Document>> changes, Collection<Optional<Document>> worklogs) {
            Preconditions.checkArgument((boolean)issueDocument.isPresent(), (Object)"Issue document must be defined");
            this.issueDocument = issueDocument.get();
            this.comments = this.filterNotEmpty(comments);
            this.changes = this.filterNotEmpty(changes);
            this.worklogs = this.filterNotEmpty(worklogs);
            this.term = DefaultIssueIndexer.this.issueDocumentFactory.getIdentifyingTerm(issue);
        }

        public Document getIssue() {
            return this.issueDocument;
        }

        public List<Document> getComments() {
            return this.comments;
        }

        public List<Document> getWorklogs() {
            return this.worklogs;
        }

        public List<Document> getChanges() {
            return this.changes;
        }

        public Term getIdentifyingTerm() {
            return this.term;
        }

        private <T> List<T> filterNotEmpty(Collection<Optional<T>> optionalDocuments) {
            return optionalDocuments.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
    }

    private abstract class RelatedEntityOperation<R extends WithId>
    extends EntityOperation<R, Document> {
        final RelatedEntityDocumentFactory<R> documentFactory;
        final Set<WithIdAndVersion> relatedEntityReplicationBuffer;

        RelatedEntityOperation(boolean shouldReplicate, IndexDirectoryFactory.Name index, RelatedEntityDocumentFactory<R> documentFactory) {
            super(index, shouldReplicate);
            this.relatedEntityReplicationBuffer = new LinkedHashSet<WithIdAndVersion>();
            this.documentFactory = documentFactory;
        }

        @Override
        final Ticker getTicker(R entity) {
            Ticker profilingTicker = Timers.start((String)("Index " + this.index.name()));
            Ticker metricTicker = Metrics.metric((String)String.format("%s.reindexing", this.index.name().toLowerCase())).withInvokerPluginKey().withAnalytics().startLongRunningTimer();
            return () -> {
                profilingTicker.close();
                metricTicker.close();
            };
        }

        @Override
        final Ticker getTicker(Collection<R> entities) {
            Ticker profilingTicker = Timers.start((String)("Index " + this.index.name()));
            Ticker metricTicker = Metrics.metric((String)String.format("%s.reindexing", this.index.name().toLowerCase())).withInvokerPluginKey().withAnalytics().startLongRunningTimer();
            return () -> {
                profilingTicker.close();
                metricTicker.close();
            };
        }

        @Override
        final Index.Result createResult(R entity, Context.Task task, Document document) {
            Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
            return DefaultIssueIndexer.this.lifecycle.getIndex(this.index).perform(Operations.newConditionalUpdateWithVersion(document, mode));
        }

        @Override
        final void replicate(Document document, long cost) {
            DefaultIssueIndexer.this.dbrSender.sendUpdate(this.index, document, cost);
            this.relatedEntityReplicationBuffer.add(WithIdAndVersion.fromDocument(this.index, document));
        }

        @Override
        final Optional<Document> createDocument(EntityWithVersion<R> entity) {
            return this.documentFactory.createDocument(entity);
        }
    }

    private static class TaskCompleter
    implements Runnable {
        private final Context.Task task;

        public TaskCompleter(Context.Task task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.complete();
        }
    }

    private final class WorklogOperation
    extends RelatedEntityOperation<Worklog> {
        WorklogOperation(boolean shouldReplicate) {
            super(shouldReplicate, IndexDirectoryFactory.Name.WORKLOG, DefaultIssueIndexer.this.worklogDocumentFactory);
        }

        @Override
        boolean shouldDeindex(Worklog entity) {
            if (entity.getIssue() == null || entity.getIssue().isArchived()) {
                log.debug("Asked to (re)index an archived worklog with id {}. The worklog will be deindexed.", (Object)entity.getId());
                return true;
            }
            Optional<EntityVersion> version = this.getVersion(entity.getId());
            if (version.isPresent() && version.get().isDeleted()) {
                log.debug("Asked to (re)index a deleted worklog with id {}. The worklog will be deindexed.", (Object)entity.getId());
                return true;
            }
            return false;
        }

        @Override
        boolean shouldSkip(Worklog entity) {
            return false;
        }

        @Override
        Optional<Worklog> getEntity(long entityId) {
            return DefaultIssueIndexer.this.worklogRetriever.retrieveById(entityId);
        }

        @Override
        Optional<EntityVersion> getVersion(long entityId) {
            return DefaultIssueIndexer.this.entityVersioningManager.getWorklogEntityVersion(entityId);
        }

        @Override
        void bumpVersion(Worklog entity) {
            DefaultIssueIndexer.this.entityVersioningManager.incrementWorklogVersion(entity.getId(), entity.getIssue().getId());
        }

        @Override
        void deindex(Worklog entity) {
            DefaultIssueIndexer.this.deindexWorklogs(Collections.singletonList(entity), Contexts.nullContext(), false);
        }

        @Override
        public void close() {
            super.close();
            if (!this.relatedEntityReplicationBuffer.isEmpty()) {
                DefaultIssueIndexer.this.replicatedIndexManager.reindexWorklogs((Collection<? extends WithIdAndVersion>)ImmutableSet.copyOf((Collection)this.relatedEntityReplicationBuffer));
                this.relatedEntityReplicationBuffer.clear();
            } else if (this.shouldReplicate && this.performCounter.get() > 0) {
                log.warn("No worklog to replicate, performCounter: {}", (Object)this.performCounter.get(), (Object)new Throwable());
            }
        }
    }

    private final class CommentOperation
    extends RelatedEntityOperation<Comment> {
        CommentOperation(boolean shouldReplicate) {
            super(shouldReplicate, IndexDirectoryFactory.Name.COMMENT, DefaultIssueIndexer.this.commentDocumentFactory);
        }

        @Override
        boolean shouldDeindex(Comment entity) {
            if (entity.getIssue() == null || entity.getIssue().isArchived()) {
                log.debug("Asked to (re)index an archived comment with id {}. The comment will be deindexed.", (Object)entity.getId());
                return true;
            }
            Optional<EntityVersion> version = this.getVersion(entity.getId());
            if (version.isPresent() && version.get().isDeleted()) {
                log.debug("Asked to (re)index a deleted comment with id {}. The comment will be deindexed.", (Object)entity.getId());
                return true;
            }
            return false;
        }

        @Override
        boolean shouldSkip(Comment entity) {
            return false;
        }

        @Override
        Optional<Comment> getEntity(long entityId) {
            return DefaultIssueIndexer.this.commentRetriever.retrieveById(entityId);
        }

        @Override
        Optional<EntityVersion> getVersion(long entityId) {
            return DefaultIssueIndexer.this.entityVersioningManager.getCommentEntityVersion(entityId);
        }

        @Override
        void bumpVersion(Comment entity) {
            DefaultIssueIndexer.this.entityVersioningManager.incrementCommentVersion(entity.getId(), entity.getIssue().getId());
        }

        @Override
        void deindex(Comment entity) {
            DefaultIssueIndexer.this.deindexComments(Collections.singletonList(entity), Contexts.nullContext(), false);
        }

        @Override
        public void close() {
            super.close();
            if (!this.relatedEntityReplicationBuffer.isEmpty()) {
                DefaultIssueIndexer.this.replicatedIndexManager.reindexComments((Collection<? extends WithIdAndVersion>)ImmutableSet.copyOf((Collection)this.relatedEntityReplicationBuffer));
                this.relatedEntityReplicationBuffer.clear();
            } else if (this.shouldReplicate && this.performCounter.get() > 0) {
                log.warn("No comment to replicate, performCounter: {}", (Object)this.performCounter.get(), (Object)new Throwable());
            }
        }
    }

    private final class ReIndexIssuesOperation
    extends IssuesOperation {
        final boolean conditionalUpdate;

        ReIndexIssuesOperation(boolean shouldReplicate, IssueIndexingParams issueIndexingParams, boolean conditionalUpdate) {
            super(true, shouldReplicate, issueIndexingParams);
            this.conditionalUpdate = conditionalUpdate;
        }

        @Override
        Ticker getTicker(Issue issue) {
            return IndexingTimers.REINDEX_ISSUE_OPERATION.get().start(new Object[]{issue.getKey(), issue.getId()});
        }

        @Override
        Ticker getTicker(Collection<Issue> issues) {
            return (Ticker)ISSUES_TICKET_FUNCTION.apply(issues);
        }

        @Override
        Index.Result createResult(Issue issue, Context.Task task, Documents documents) {
            Index.Operation operation;
            boolean conditionalUpdateWithVersion;
            AccumulatingResultBuilder results = new AccumulatingResultBuilder();
            Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
            Term issueTerm = documents.getIdentifyingTerm();
            boolean bl = conditionalUpdateWithVersion = this.conditionalUpdate || this.shouldReplicate;
            if (this.issueIndexingParams.isIndexIssues()) {
                Index.Operation update = conditionalUpdateWithVersion ? Operations.newConditionalUpdateWithVersion(documents.getIssue(), mode) : Operations.newUpdate(issueTerm, documents.getIssue(), mode);
                results.add("Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(Operations.newCompletionDelegate(update, new TaskCompleter(task))));
            }
            if (this.issueIndexingParams.isIndexComments()) {
                operation = conditionalUpdateWithVersion && !documents.getComments().isEmpty() ? Operations.newConditionalUpdateWithVersion(documents.getComments(), mode) : Operations.newUpdate(issueTerm, documents.getComments(), mode);
                results.add("Comment For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(operation));
            }
            if (this.issueIndexingParams.isIndexChangeHistory()) {
                operation = conditionalUpdateWithVersion && !documents.getChanges().isEmpty() ? Operations.newConditionalReplaceCollection(documents.getChanges(), mode) : Operations.newUpdate(issueTerm, documents.getChanges(), mode);
                results.add("Change History For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(operation));
            }
            if (this.issueIndexingParams.isIndexWorklogs()) {
                operation = conditionalUpdateWithVersion && !documents.getWorklogs().isEmpty() ? Operations.newConditionalUpdateWithVersion(documents.getWorklogs(), mode) : Operations.newUpdate(issueTerm, documents.getWorklogs(), mode);
                results.add("Worklog For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getWorklogIndex().perform(operation));
            }
            return results.toResult();
        }
    }

    private final class IndexIssueOperation
    extends IssuesOperation {
        private final Index.UpdateMode mode;

        IndexIssueOperation(boolean skipArchived, boolean shouldReplicate, IssueIndexingParams issueIndexingParams, Index.UpdateMode mode) {
            super(skipArchived, shouldReplicate, issueIndexingParams);
            this.mode = mode;
        }

        @Override
        Ticker getTicker(Issue issue) {
            return IndexingTimers.INDEX_ISSUE_OPERATION.start(new Object[]{issue.getKey(), issue.getId()});
        }

        @Override
        Ticker getTicker(Collection<Issue> issues) {
            return (Ticker)ISSUES_TICKET_FUNCTION.apply(issues);
        }

        @Override
        Index.Result createResult(Issue issue, Context.Task task, Documents documents) {
            AccumulatingResultBuilder results = new AccumulatingResultBuilder();
            Index.Operation issueCreate = Operations.newCreate(documents.getIssue(), this.mode);
            Index.Operation onCompletion = Operations.newCompletionDelegate(issueCreate, new TaskCompleter(task));
            results.add("Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(onCompletion));
            if (!documents.getComments().isEmpty()) {
                Index.Operation commentsCreate = Operations.newCreate(documents.getComments(), this.mode);
                results.add("Comment For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(commentsCreate));
            }
            if (!documents.getChanges().isEmpty()) {
                Index.Operation changeHistoryCreate = Operations.newCreate(documents.getChanges(), this.mode);
                results.add("Change History For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(changeHistoryCreate));
            }
            if (!documents.getWorklogs().isEmpty()) {
                Index.Operation worklogsCreate = Operations.newCreate(documents.getWorklogs(), this.mode);
                results.add("Worklog For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getWorklogIndex().perform(worklogsCreate));
            }
            return results.toResult();
        }
    }

    private abstract class IssuesOperation
    extends EntityOperation<Issue, Documents> {
        private final boolean skipArchived;
        private final Set<WithIdAndVersion> issuesReplicationBuffer;
        private final Set<WithIdAndVersion> commentReplicationBuffer;
        private final Set<WithIdAndVersion> worklogReplicationBuffer;
        final IssueIndexingParams issueIndexingParams;

        IssuesOperation(boolean skipArchived, boolean shouldReplicate, IssueIndexingParams issueIndexingParams) {
            super(IndexDirectoryFactory.Name.ISSUE, shouldReplicate);
            this.issuesReplicationBuffer = new LinkedHashSet<WithIdAndVersion>();
            this.commentReplicationBuffer = new LinkedHashSet<WithIdAndVersion>();
            this.worklogReplicationBuffer = new LinkedHashSet<WithIdAndVersion>();
            this.skipArchived = skipArchived;
            this.issueIndexingParams = IssueIndexingParams.builder((IssueIndexingParams)issueIndexingParams).withChangeHistory().build();
        }

        @Override
        final Optional<Issue> getEntity(long entityId) {
            return Optional.ofNullable(DefaultIssueIndexer.this.issueManager.getIssueObject(Long.valueOf(entityId)));
        }

        @Override
        Optional<EntityVersion> getVersion(long entityId) {
            return DefaultIssueIndexer.this.entityVersioningManager.getIssueEntityVersion(entityId);
        }

        @Override
        final boolean shouldDeindex(Issue entity) {
            if (this.skipArchived && entity.isArchived()) {
                log.debug("Asked to (re)index an archived issue with id {}. The issue will be deindexed.", (Object)entity.getId());
                return true;
            }
            Optional<EntityVersion> version = this.getVersion(entity.getId());
            if (version.isPresent() && version.get().isDeleted()) {
                log.debug("Asked to (re)index a deleted issue with id {}. The issue will be deindexed.", (Object)entity.getId());
                return true;
            }
            return false;
        }

        @Override
        final boolean shouldSkip(Issue entity) {
            if (entity.getNumber() == null) {
                log.warn("Issue with id '{}' is corrupted. Skipping indexing of that issue", (Object)entity.getId());
                return true;
            }
            return false;
        }

        @Override
        final void bumpVersion(Issue issue) {
            DefaultIssueIndexer.this.entityVersioningManager.incrementIssueVersion(issue.getId());
            if (this.issueIndexingParams.isIndexComments()) {
                DefaultIssueIndexer.this.entityVersioningManager.incrementRelatedCommentVersions(issue.getId());
            }
            if (this.issueIndexingParams.isIndexWorklogs()) {
                DefaultIssueIndexer.this.entityVersioningManager.incrementRelatedWorklogVersions(issue.getId());
            }
        }

        @Override
        final void replicate(Documents documents, long cost) {
            DefaultIssueIndexer.this.dbrSender.sendUpdateWithRelated(documents, cost);
            this.issuesReplicationBuffer.add(WithIdAndVersion.fromDocument(IndexDirectoryFactory.Name.ISSUE, documents.issueDocument));
            if (this.issueIndexingParams.isIndexComments()) {
                this.commentReplicationBuffer.addAll(WithIdAndVersion.fromDocuments(IndexDirectoryFactory.Name.COMMENT, documents.getComments()));
            }
            if (this.issueIndexingParams.isIndexWorklogs()) {
                this.worklogReplicationBuffer.addAll(WithIdAndVersion.fromDocuments(IndexDirectoryFactory.Name.WORKLOG, documents.getWorklogs()));
            }
        }

        @Override
        final Optional<Documents> createDocument(EntityWithVersion<Issue> entity) {
            return Optional.of(DefaultIssueIndexer.this.documentCreationStrategy.get(entity, this.issueIndexingParams));
        }

        @Override
        final Map<EntityWithVersion<Issue>, Optional<Documents>> createDocuments(List<EntityWithVersion<Issue>> entities) {
            return DefaultIssueIndexer.this.documentCreationStrategy.get(entities, this.issueIndexingParams);
        }

        @Override
        void deindex(Issue entity) {
            DefaultIssueIndexer.this.deindexIssues(Collections.singletonList(entity), Contexts.nullContext(), false);
        }

        @Override
        public void close() {
            super.close();
            if (!this.issuesReplicationBuffer.isEmpty()) {
                DefaultIssueIndexer.this.replicatedIndexManager.reindexIssues((Collection<? extends WithIdAndVersion>)ImmutableList.copyOf(this.issuesReplicationBuffer));
                this.issuesReplicationBuffer.clear();
            } else if (this.shouldReplicate && this.performCounter.get() > 0) {
                log.warn("No issues to replicate: numberOfCommentsToReplicate: {}, numberOfWorklogsToReplicate: {}, issueIndexingParams: {}, performCounter: {}", new Object[]{this.commentReplicationBuffer.size(), this.worklogReplicationBuffer.size(), this.issueIndexingParams, this.performCounter.get(), new Throwable()});
            }
            if (!this.commentReplicationBuffer.isEmpty()) {
                DefaultIssueIndexer.this.replicatedIndexManager.reindexComments((Collection<? extends WithIdAndVersion>)ImmutableList.copyOf(this.commentReplicationBuffer));
                this.commentReplicationBuffer.clear();
            }
            if (!this.worklogReplicationBuffer.isEmpty()) {
                DefaultIssueIndexer.this.replicatedIndexManager.reindexWorklogs((Collection<? extends WithIdAndVersion>)ImmutableList.copyOf(this.worklogReplicationBuffer));
                this.worklogReplicationBuffer.clear();
            }
        }
    }

    private static abstract class EntityOperation<E extends WithId, D>
    implements AutoCloseable {
        final IndexDirectoryFactory.Name index;
        final boolean shouldReplicate;
        final AtomicInteger performCounter = new AtomicInteger();
        final AtomicBoolean closed = new AtomicBoolean(false);

        EntityOperation(IndexDirectoryFactory.Name index, boolean shouldReplicate) {
            this.index = index;
            this.shouldReplicate = shouldReplicate;
        }

        void checkNotClosed() {
            Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Operation already closed");
        }

        public IndexDirectoryFactory.Name getIndexName() {
            return this.index;
        }

        final void bumpVersionIfNeeded(E entity) {
            this.checkNotClosed();
            if (this.shouldReplicate) {
                this.bumpVersion(entity);
            }
        }

        final Optional<EntityWithVersion<E>> reload(E inputEntity) {
            this.checkNotClosed();
            Optional<Long> mayVersion = this.getVersion(inputEntity.getId()).map(EntityVersion::getVersion);
            return this.getEntity(inputEntity.getId()).map(reloadedIssue -> new EntityWithVersion<WithId>((WithId)reloadedIssue, mayVersion.orElseGet(() -> {
                log.warn("{} with id={} should have a version by now", (Object)this.index, (Object)inputEntity.getId());
                Preconditions.checkState((!this.shouldReplicate ? 1 : 0) != 0, (String)"%s with id=%s should have a version by now", (Object)((Object)this.index), (Object)inputEntity.getId());
                return EntityDocumentFactory.ENTITY_VERSION_ZERO;
            })));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final Index.Result perform(EntityWithVersion<E> entity, Context.Task task) {
            this.checkNotClosed();
            this.performCounter.incrementAndGet();
            try (Ticker ignored = this.getTicker(entity.getEntity());){
                Stopwatch cost = Stopwatch.createStarted();
                Optional<D> maybeDocument = this.createDocument(entity);
                cost.stop();
                if (this.shouldReplicate) {
                    maybeDocument.ifPresent(document -> this.replicate(document, cost.elapsed(TimeUnit.MILLISECONDS)));
                }
                Index.Result result = maybeDocument.map(d -> this.createResult(entity.getEntity(), task, d)).orElse(new DefaultIndex.Failure(new RuntimeException("Entity undefined")));
                return result;
            }
            catch (Exception ex) {
                return new DefaultIndex.Failure(ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final Index.Result perform(Map<EntityWithVersion<E>, Context.Task> entitiesWithTasks) {
            this.checkNotClosed();
            this.performCounter.addAndGet(entitiesWithTasks.size());
            try (Ticker ignored = this.getTicker(entitiesWithTasks.keySet().stream().map(EntityWithVersion::getEntity).collect(Collectors.toList()));){
                Stopwatch cost = Stopwatch.createStarted();
                Map<EntityWithVersion<E>, Optional<D>> documents = this.createDocuments(new ArrayList<EntityWithVersion<E>>(entitiesWithTasks.keySet()));
                cost.stop();
                if (this.shouldReplicate) {
                    documents.values().forEach(maybeDocument -> maybeDocument.ifPresent(document -> this.replicate(document, cost.elapsed(TimeUnit.MILLISECONDS))));
                }
                Index.Result result = this.createResult(entitiesWithTasks, documents);
                return result;
            }
            catch (Exception ex) {
                AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
                entitiesWithTasks.forEach((k, v) -> builder.add(new DefaultIndex.Failure(ex)));
                return builder.toResult();
            }
        }

        abstract boolean shouldDeindex(E var1);

        abstract boolean shouldSkip(E var1);

        abstract Ticker getTicker(E var1);

        abstract Ticker getTicker(Collection<E> var1);

        abstract Optional<E> getEntity(long var1);

        abstract Optional<EntityVersion> getVersion(long var1);

        abstract Index.Result createResult(E var1, Context.Task var2, D var3);

        Index.Result createResult(Map<EntityWithVersion<E>, Context.Task> entitiesWithTasks, Map<EntityWithVersion<E>, Optional<D>> documents) {
            AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
            documents.forEach((key, value) -> builder.add(value.map(d -> this.createResult(key.getEntity(), (Context.Task)entitiesWithTasks.get(key), d)).orElse(new DefaultIndex.Failure(new RuntimeException("Entity undefined")))));
            return builder.toResult();
        }

        abstract void bumpVersion(E var1);

        abstract void replicate(D var1, long var2);

        abstract void deindex(E var1);

        abstract Optional<D> createDocument(EntityWithVersion<E> var1);

        Map<EntityWithVersion<E>, Optional<D>> createDocuments(List<EntityWithVersion<E>> entities) {
            return entities.stream().collect(Collectors.toMap(Function.identity(), this::createDocument));
        }

        @Override
        public void close() {
            Preconditions.checkState((boolean)this.closed.compareAndSet(false, true), (Object)"Operation already closed.");
        }
    }

    static interface DocumentCreationStrategy {
        public Documents get(EntityWithVersion<Issue> var1, IssueIndexingParams var2);

        default public Map<EntityWithVersion<Issue>, Optional<Documents>> get(List<EntityWithVersion<Issue>> input, IssueIndexingParams issueIndexingParams) {
            return input.stream().collect(Collectors.toMap(Function.identity(), entity -> Optional.of(this.get((EntityWithVersion<Issue>)entity, issueIndexingParams))));
        }
    }

    private class DeindexWorklogOperation
    extends DeindexRelatedEntityOperation {
        DeindexWorklogOperation(boolean shouldReplicate) {
            super(IndexDirectoryFactory.Name.WORKLOG, shouldReplicate);
        }

        @Override
        Optional<Long> markAsDeleteAndGetIncreasedVersion(Long entityId) {
            DefaultIssueIndexer.this.entityVersioningManager.markWorklogDeletedAndIncrementVersion(entityId);
            return DefaultIssueIndexer.this.entityVersioningManager.getWorklogVersion(entityId);
        }

        @Override
        protected void replicate(WithIdAndVersion entity) {
            DefaultIssueIndexer.this.replicatedIndexManager.deIndexWorklog(entity);
        }
    }

    private class DeindexCommentOperation
    extends DeindexRelatedEntityOperation {
        DeindexCommentOperation(boolean shouldReplicate) {
            super(IndexDirectoryFactory.Name.COMMENT, shouldReplicate);
        }

        @Override
        Optional<Long> markAsDeleteAndGetIncreasedVersion(Long entityId) {
            DefaultIssueIndexer.this.entityVersioningManager.markCommentDeletedAndIncrementVersion(entityId);
            return DefaultIssueIndexer.this.entityVersioningManager.getCommentVersion(entityId);
        }

        @Override
        protected void replicate(WithIdAndVersion entity) {
            DefaultIssueIndexer.this.replicatedIndexManager.deIndexComment(entity);
        }
    }

    private abstract class DeindexRelatedEntityOperation
    extends DeindexEntityOperation {
        DeindexRelatedEntityOperation(IndexDirectoryFactory.Name index, boolean shouldReplicate) {
            super(index, shouldReplicate);
        }

        @Override
        protected AccumulatingResultBuilder createResult(Long entityId, Index.Operation delete) {
            AccumulatingResultBuilder currIdResults = new AccumulatingResultBuilder();
            currIdResults.add("entity For " + (Object)((Object)this.index), entityId, DefaultIssueIndexer.this.lifecycle.get(this.index).getIndex().perform(delete));
            return currIdResults;
        }
    }

    private class DeindexIssueOperation
    extends DeindexEntityOperation {
        DeindexIssueOperation(boolean shouldReplicate) {
            super(IndexDirectoryFactory.Name.ISSUE, shouldReplicate);
        }

        @Override
        protected void replicate(WithIdAndVersion entity) {
            DefaultIssueIndexer.this.replicatedIndexManager.deIndexIssue(entity);
        }

        @Override
        Optional<Long> markAsDeleteAndGetIncreasedVersion(Long entityId) {
            DefaultIssueIndexer.this.entityVersioningManager.markIssueDeletedAndIncrementVersion(entityId);
            return DefaultIssueIndexer.this.entityVersioningManager.getIssueVersion(entityId);
        }

        @Override
        protected AccumulatingResultBuilder createResult(Long entityId, Index.Operation delete) {
            AccumulatingResultBuilder currIdResults = new AccumulatingResultBuilder();
            currIdResults.add("Issue", entityId, DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(delete));
            currIdResults.add("Comment For Issue", entityId, DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(delete));
            currIdResults.add("Change History For Issue", entityId, DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(delete));
            currIdResults.add("Worklog For Issue", entityId, DefaultIssueIndexer.this.lifecycle.getWorklogIndex().perform(delete));
            return currIdResults;
        }
    }

    private abstract class DeindexEntityOperation {
        final IndexDirectoryFactory.Name index;
        final boolean shouldReplicate;

        DeindexEntityOperation(IndexDirectoryFactory.Name index, boolean shouldReplicate) {
            this.index = index;
            this.shouldReplicate = shouldReplicate;
        }

        final Index.Result perform(WithId entity) {
            Long entityId = entity.getId();
            try {
                if (this.shouldReplicate) {
                    Optional<Long> version = this.markAsDeleteAndGetIncreasedVersion(entityId);
                    if (version.isPresent()) {
                        this.replicate(WithIdAndVersion.of(entity.getId(), version.get()));
                    } else {
                        log.error("Was not able to replicate deindex of {} from index {} because no version for this entity was retrieved. This situation should not have happened as the version should always exist at this point. This entity deletion will not be replicated to other nodes", (Object)entity, (Object)this.index);
                    }
                }
            }
            catch (Exception ex) {
                log.warn("Can't replicate {} for id '{}':", new Object[]{this.index, entityId, ex});
                return new DefaultIndex.Failure(ex);
            }
            try {
                Term deleteTerm = new Term(this.index.getEntityIdFieldName(), entityId.toString());
                Index.Operation delete = Operations.newDelete(deleteTerm, Index.UpdateMode.INTERACTIVE);
                AccumulatingResultBuilder currIdResults = this.createResult(entityId, delete);
                log.trace("deindexed {} for id '{}'", (Object)this.index, (Object)entityId);
                return currIdResults.toResult();
            }
            catch (Exception ex) {
                log.warn("Problems deindexing {} for id '{}':", new Object[]{this.index, entityId, ex});
                return new DefaultIndex.Failure(ex);
            }
        }

        abstract Optional<Long> markAsDeleteAndGetIncreasedVersion(Long var1);

        public IndexDirectoryFactory.Name getIndexName() {
            return this.index;
        }

        protected abstract AccumulatingResultBuilder createResult(Long var1, Index.Operation var2);

        protected abstract void replicate(WithIdAndVersion var1);
    }

    public static interface WorklogRetriever
    extends EntityRetriever<Worklog> {
        public Optional<Worklog> retrieveById(Long var1);
    }

    public static interface ChangeHistoryRetriever
    extends EntityRetriever<ChangeHistoryGroup> {
    }

    public static interface CommentRetriever
    extends EntityRetriever<Comment> {
        public Optional<Comment> retrieveById(Long var1);
    }

    public static interface EntityRetriever<T extends WithId> {
        public List<EntityWithVersion<T>> retrieve(EntityWithVersion<Issue> var1);
    }
}

