/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.index.indexers.impl.UserFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class AssigneeIndexer
extends UserFieldIndexer {
    public AssigneeIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    public String getId() {
        return SystemSearchConstants.forAssignee().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forAssignee().getIndexField();
    }

    public void addIndex(Document doc, Issue issue) {
        String assigneeId = issue.getAssigneeId();
        this.indexUserkeyWithDefault(doc, this.getDocumentFieldId(), assigneeId, "unassigned", issue);
        if (assigneeId != null) {
            SecurityIndexingUtils.indexPermissions((Document)doc, (Issue)issue, (String)this.getDocumentFieldId(), (String)assigneeId);
        }
    }
}

