/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class CustomFieldLabelsIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    public static final String FOLDED_EXT = "_folded";

    public CustomFieldLabelsIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
        this.customField = customField;
    }

    public String getDocumentFieldId() {
        return this.customField.getId() + FOLDED_EXT;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue, CustomFieldPrefetchedData customFieldPrefetchedData) {
        this.addIndex(doc, issue, true, customFieldPrefetchedData);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue, CustomFieldPrefetchedData customFieldPrefetchedData) {
        this.addIndex(doc, issue, false, customFieldPrefetchedData);
    }

    private void addIndex(Document doc, Issue issue, boolean searchable, CustomFieldPrefetchedData customFieldPrefetchedData) {
        Set labels = (Set)customFieldPrefetchedData.getData().orElseGet(() -> this.customField.getValue(issue));
        if (labels == null || labels.isEmpty()) {
            if (searchable) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), "<EMPTY>", Field.Store.NO));
                doc.add((IndexableField)new SortedDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)"<EMPTY>")));
            }
        } else {
            for (Label label : labels) {
                String theLabel = label.getLabel();
                if (!StringUtils.isNotBlank((CharSequence)theLabel)) continue;
                if (searchable) {
                    doc.add((IndexableField)new StringField(this.customField.getId(), theLabel, Field.Store.YES));
                    doc.add((IndexableField)new StringField(this.getDocumentFieldId(), theLabel.toLowerCase(), Field.Store.NO));
                    doc.add((IndexableField)new SortedSetDocValuesField(this.customField.getId(), new BytesRef((CharSequence)theLabel)));
                    continue;
                }
                doc.add((IndexableField)new StoredField(this.customField.getId(), theLabel));
            }
        }
    }
}

