/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class ProjectCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField customField;
    private final ProjectConverter projectConverter;

    public ProjectCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, ProjectConverter projectConverter) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.projectConverter = projectConverter;
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    public Boolean skipsIndexingNull() {
        return true;
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        if (value != null) {
            String projectAsString = this.projectConverter.getString((Project)value);
            if (searchable) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), projectAsString, Field.Store.YES));
                doc.add((IndexableField)new SortedDocValuesField(this.getDocumentFieldId(), new BytesRef((CharSequence)projectAsString)));
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), projectAsString));
            }
        }
    }
}

