/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelComparator;
import com.atlassian.jira.issue.label.LabelStore;
import com.atlassian.jira.issue.label.OfBizLabelStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

@EventComponent
public class CachingLabelStore
implements LabelStore,
Startable {
    private final OfBizLabelStore delegateStore;
    private final Cache<Long, Collection<Label>> cache;

    public CachingLabelStore(OfBizLabelStore delegateStore, CacheManager cacheManager) {
        this.delegateStore = delegateStore;
        this.cache = cacheManager.getCache(this.getClass().getName() + ".cache", this::loadCacheLabels, new CacheSettingsBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maxEntries(1000).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    @Override
    public Set<Label> getLabels(Long issueId, Long customFieldId) {
        return ((Collection)this.cache.get((Object)issueId)).stream().filter(x -> Objects.equals(x.getCustomFieldId(), customFieldId)).collect(Collectors.toCollection(() -> new TreeSet(LabelComparator.INSTANCE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Label> setLabels(Long issueId, Long customFieldId, Set<String> labels) {
        try {
            Set<Label> set = this.delegateStore.setLabels(issueId, customFieldId, labels);
            return set;
        }
        finally {
            this.cache.remove((Object)issueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Label addLabel(Long issueId, Long customFieldId, String label) {
        try {
            Label label2 = this.delegateStore.addLabel(issueId, customFieldId, label);
            return label2;
        }
        finally {
            this.cache.remove((Object)issueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLabel(Long labelId, Long issueId, Long customFieldId) {
        try {
            this.delegateStore.removeLabel(labelId, issueId, customFieldId);
        }
        finally {
            this.cache.remove((Object)issueId);
        }
    }

    @Override
    public Set<Long> removeLabelsForCustomField(Long customFieldId) {
        try {
            Set<Long> set = this.delegateStore.removeLabelsForCustomField(customFieldId);
            return set;
        }
        finally {
            this.cache.removeAll();
        }
    }

    @Override
    public Collection<Label> getLabels(long issueId) {
        return (Collection)this.cache.get((Object)issueId);
    }

    @Override
    public Map<Long, Collection<Label>> getLabels(Set<Long> issueIds) {
        return issueIds.stream().collect(Collectors.toMap(Function.identity(), this::getLabels));
    }

    public void start() throws Exception {
    }

    private Collection<Label> loadCacheLabels(long issueId) {
        return Collections.unmodifiableCollection(this.delegateStore.getLabels(issueId));
    }
}

