/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.managers.ArchivingDao;
import com.atlassian.jira.issue.managers.DefaultArchivingDao;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

public class ZduAwareArchivingDao
implements ArchivingDao {
    private final OfBizDelegator ofBizDelegator;
    private final FeatureManager featureManager;
    private final ProjectManager projectManager;
    private final ArchivingDao delegate;
    private boolean projectArchivedIssuesMarkedInIssueTable;

    public ZduAwareArchivingDao(OfBizDelegator ofBizDelegator, FeatureManager featureManager, ProjectManager projectManager, ArchivingDao delegate) {
        this.ofBizDelegator = ofBizDelegator;
        this.featureManager = featureManager;
        this.projectManager = projectManager;
        this.delegate = delegate;
    }

    @Override
    public long getActiveIssueCount() {
        if (this.isProjectArchivedIssuesMarkedInIssueTable()) {
            return this.delegate.getActiveIssueCount();
        }
        List activeProjectIds = this.projectManager.getProjects().stream().map(Project::getId).collect(Collectors.toList());
        if (activeProjectIds.isEmpty()) {
            return 0L;
        }
        EntityExpr whereProjectActive = new EntityExpr("project", EntityOperator.IN, activeProjectIds);
        EntityCondition whereIssueActive = DefaultArchivingDao.getIsNotArchivedIssueExpression();
        EntityConditionList whereProjectActiveAndIssueActive = new EntityConditionList((List)ImmutableList.of((Object)whereProjectActive, (Object)whereIssueActive), EntityOperator.AND);
        return this.ofBizDelegator.getCountByAnd("Issue", (EntityCondition)whereProjectActiveAndIssueActive);
    }

    @Override
    public long archiveIssuesInProject(Project project) {
        if (this.isProjectArchivedIssuesMarkedInIssueTable()) {
            return this.delegate.archiveIssuesInProject(project);
        }
        return 0L;
    }

    @Override
    public long restoreIssuesInProject(Project project) {
        if (this.isProjectArchivedIssuesMarkedInIssueTable()) {
            return this.delegate.restoreIssuesInProject(project);
        }
        return 0L;
    }

    private boolean isProjectArchivedIssuesMarkedInIssueTable() {
        if (!this.projectArchivedIssuesMarkedInIssueTable) {
            this.projectArchivedIssuesMarkedInIssueTable = this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PROJECT_ARCHIVED_ISSUES_MARKED_IN_ISSUE_TABLE);
        }
        return this.projectArchivedIssuesMarkedInIssueTable;
    }
}

