/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.IssueConstantsSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class PrioritySearchRenderer
extends IssueConstantsSearchRenderer<Priority>
implements SearchRenderer {
    private final ConstantsManager constantsManager;
    private final PrioritySchemeManager prioritySchemeManager;

    public PrioritySearchRenderer(String searcherNameKey, ConstantsManager constantsManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager, PrioritySchemeManager prioritySchemeManager) {
        super(SystemSearchConstants.forPriority(), searcherNameKey, constantsManager, velocityRequestContextFactory, applicationProperties, templatingEngine, fieldVisibilityManager);
        this.constantsManager = constantsManager;
        this.prioritySchemeManager = prioritySchemeManager;
    }

    @Override
    public Collection<Priority> getSelectListOptions(SearchContext searchContext) {
        List projectIds = searchContext.getProjectIds();
        if (projectIds == null || projectIds.isEmpty()) {
            return this.constantsManager.getPriorities();
        }
        return projectIds.stream().map(projectId -> this.prioritySchemeManager.getOptions((IssueContext)new ProjectContext(projectId))).map(arg_0 -> ((PrioritySchemeManager)this.prioritySchemeManager).getPrioritiesFromIds(arg_0)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }
}

