/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.searchers.transformer.TextQueryValidator;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import com.atlassian.query.operand.Operand;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;

public abstract class AbstractSearchInputTransformer
implements SearchInputTransformer {
    protected JqlOperandResolver operandResolver;
    protected final String fieldsKey;
    protected final String id;
    private final TextQueryValidator textQueryValidator;

    public AbstractSearchInputTransformer(JqlOperandResolver operandResolver, String id, String fieldsKey) {
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.id = id;
        this.fieldsKey = fieldsKey;
        this.textQueryValidator = new TextQueryValidator();
    }

    protected boolean hasDuplicates(List<TerminalClause> foundChildren) {
        HashSet<String> containsSet = new HashSet<String>();
        for (TerminalClause foundChild : foundChildren) {
            if (containsSet.add(foundChild.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasEmpties(List<TerminalClause> foundChildren) {
        for (TerminalClause foundChild : foundChildren) {
            Operand operand = foundChild.getOperand();
            if (!this.operandResolver.isEmptyOperand(operand)) continue;
            return true;
        }
        return false;
    }

    protected String getValueForField(List<TerminalClause> terminalClauses, ApplicationUser user, String ... jqlClauseNames) {
        return this.getValueForField(terminalClauses, user, Arrays.asList(jqlClauseNames));
    }

    protected String getValueForField(List<TerminalClause> terminalClauses, ApplicationUser user, Collection<String> jqlClauseNames) {
        Operand operand;
        QueryLiteral rawValue;
        TerminalClause theClause = null;
        for (TerminalClause terminalClause : terminalClauses) {
            if (!jqlClauseNames.contains(terminalClause.getName())) continue;
            if (theClause != null) {
                return null;
            }
            theClause = terminalClause;
        }
        if (theClause != null && (rawValue = this.operandResolver.getSingleValue(user, operand = theClause.getOperand(), theClause)) != null && !rawValue.isEmpty()) {
            return rawValue.asString();
        }
        return null;
    }

    public void validateParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        String query = (String)fieldValuesHolder.get((Object)this.id);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            MessageSet validationResult = this.textQueryValidator.validate(this.createQueryParser(), query, this.id, null, true, i18nHelper);
            for (String errorMessage : validationResult.getErrorMessages()) {
                errors.addError(this.id, errorMessage);
            }
        }
    }

    QueryParser createQueryParser() {
        return ((LuceneQueryParserFactory)ComponentAccessor.getComponent(LuceneQueryParserFactory.class)).createParserFor(SystemSearchConstants.forSummary().getIndexField());
    }
}

