/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BytesRef;

public class PrefixFieldHitCollector
extends SimpleCollector {
    private final String fieldId;
    private final String prefix;
    private final Set<String> results;
    private SortedSetDocValues sortedSetDocValues;

    public PrefixFieldHitCollector(String fieldId, String prefix, Set<String> results) {
        this.fieldId = (String)Assertions.notNull((String)"fieldId", (Object)fieldId);
        this.results = (Set)Assertions.notNull((String)"results", results);
        this.prefix = ((String)Assertions.notNull((String)"prefix", (Object)prefix)).toLowerCase();
    }

    public void collect(int docId) throws IOException {
        if (this.sortedSetDocValues.advanceExact(docId)) {
            long ord;
            while ((ord = this.sortedSetDocValues.nextOrd()) != -1L) {
                BytesRef next = this.sortedSetDocValues.lookupOrd(ord);
                String value = next.utf8ToString();
                if (!value.toLowerCase().startsWith(this.prefix)) continue;
                this.results.add(value);
            }
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.sortedSetDocValues = context.reader().getSortedSetDocValues(this.fieldId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PrefixFieldHitCollector that = (PrefixFieldHitCollector)((Object)o);
        if (!this.fieldId.equals(that.fieldId)) {
            return false;
        }
        if (!this.prefix.equals(that.prefix)) {
            return false;
        }
        return this.results.equals(that.results);
    }

    public int hashCode() {
        int result = this.fieldId.hashCode();
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + this.results.hashCode();
        return result;
    }

    public boolean needsScores() {
        return false;
    }
}

