/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.DefaultPage;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllTabPanel
implements PaginatedIssueTabPanel {
    private final PluginAccessor pluginAccessor;
    private final IssueTabPanelInvoker issueTabPanelInvoker;
    private IssueTabPanelModuleDescriptor descriptor;
    private static Logger log = LoggerFactory.getLogger(AllTabPanel.class);

    public AllTabPanel(PluginAccessor pluginAccessor, IssueTabPanelInvoker issueTabPanelInvoker) {
        this.pluginAccessor = pluginAccessor;
        this.issueTabPanelInvoker = issueTabPanelInvoker;
    }

    public Page<IssueAction> getActions(GetActionsRequest request) {
        List<Page<IssueAction>> results = this.getEnabledTabs(request).stream().map(descriptor -> this.issueTabPanelInvoker.invokeGetActions(request, (IssueTabPanelModuleDescriptor)descriptor)).collect(Collectors.toList());
        CombinedPage page = CombinedPage.fromListOfPages(results);
        if (page.isEmpty()) {
            return DefaultPage.only(Collections.singletonList(new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.noactions"))));
        }
        return AllTabPanel.applyLimit(page, request);
    }

    private List<IssueTabPanelModuleDescriptor> getEnabledTabs(GetActionsRequest getRequest) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueTabPanelModuleDescriptor.class);
        ShowPanelRequest showRequest = new ShowPanelRequest(getRequest.issue(), getRequest.loggedInUser());
        Stream<IssueTabPanelModuleDescriptor> supportedPanels = descriptors.stream().filter(descriptor -> !descriptor.getCompleteKey().equals("com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel")).filter(descriptor -> ((PaginatedIssueTabPanel)descriptor.getModule()).paginationSupported()).filter(descriptor -> this.issueTabPanelInvoker.invokeShowPanel(showRequest, (IssueTabPanelModuleDescriptor)descriptor));
        return supportedPanels.collect(Collectors.toList());
    }

    public void init(IssueTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean showPanel(ShowPanelRequest request) {
        return true;
    }

    private static CombinedPage applyLimit(CombinedPage source, GetActionsRequest request) {
        if (request.isValidShowAllRequest()) {
            return source;
        }
        GetActionsRequest.FetchMode fetchMode = request.batching().fetchMode();
        int limit = request.batching().limit();
        if (fetchMode == GetActionsRequest.FetchMode.FROM_OLDEST || fetchMode == GetActionsRequest.FetchMode.NEWER_THAN_DATE) {
            return source.dropNewest(limit);
        }
        if (fetchMode == GetActionsRequest.FetchMode.FROM_NEWEST || fetchMode == GetActionsRequest.FetchMode.OLDER_THAN_DATE) {
            return source.dropOldest(limit);
        }
        throw new IllegalArgumentException();
    }

    private static class CombinedPage
    implements Page<IssueAction> {
        private final List<IssueAction> contents;
        private final boolean isFirst;
        private final boolean isLast;

        public static CombinedPage fromListOfPages(List<Page<IssueAction>> allPages) {
            List filteredPages = allPages.stream().filter(page -> !CombinedPage.filterActions((Page<IssueAction>)page).isEmpty()).collect(Collectors.toList());
            List<IssueAction> combined = filteredPages.stream().map(CombinedPage::filterActions).flatMap(Collection::stream).sorted(IssueActionComparator.OLDEST_FIRST).collect(Collectors.toList());
            return new CombinedPage(combined, filteredPages.stream().allMatch(Page::isFirstPage), filteredPages.stream().allMatch(Page::isLastPage));
        }

        private static List<IssueAction> filterActions(Page<IssueAction> allActions) {
            return allActions.getPageContents().stream().filter(IssueAction::isDisplayActionAllTab).filter(CombinedPage::hasValidDate).collect(Collectors.toList());
        }

        private static boolean hasValidDate(IssueAction action) {
            try {
                boolean isValid;
                boolean bl = isValid = action.getTimePerformed() != null;
                if (!isValid) {
                    log.warn("{} returned null when getting time. This isn't allowed for paginated tabs.", (Object)action);
                }
                return isValid;
            }
            catch (UnsupportedOperationException ex) {
                log.warn("{} threw UnsupportedOperationException when getting time. This isn't allowed for paginated tabs.", (Object)action);
                return false;
            }
        }

        private CombinedPage(List<IssueAction> contents, boolean isFirst, boolean isLast) {
            this.contents = contents;
            this.isFirst = isFirst;
            this.isLast = isLast;
        }

        public boolean isFirstPage() {
            return this.isFirst;
        }

        public boolean isLastPage() {
            return this.isLast;
        }

        public List<IssueAction> getPageContents() {
            return this.contents;
        }

        public CombinedPage dropNewest(int requestedSize) {
            if (this.contents.size() > requestedSize) {
                List<IssueAction> newContents = CombinedPage.limitButIncludeActionsWithDuplicatedDates(this.contents, requestedSize);
                return new CombinedPage(newContents, this.isFirst, false);
            }
            return this;
        }

        public CombinedPage dropOldest(int requestedSize) {
            if (this.contents.size() > requestedSize) {
                List newContents = Lists.reverse(CombinedPage.limitButIncludeActionsWithDuplicatedDates(Lists.reverse(this.contents), requestedSize));
                return new CombinedPage(newContents, false, this.isLast);
            }
            return this;
        }

        private static List<IssueAction> limitButIncludeActionsWithDuplicatedDates(Collection<IssueAction> collection, int requestedSize) {
            return collection.stream().reduce(new ArrayList(), (list, element) -> {
                IssueAction last;
                IssueAction issueAction = last = !list.isEmpty() ? (IssueAction)list.get(list.size() - 1) : null;
                if (list.size() < requestedSize || CombinedPage.hasSameDate(last, element)) {
                    list.add(element);
                }
                return list;
            }, (a, b) -> {
                a.addAll(b);
                return a;
            });
        }

        private static boolean hasSameDate(@Nullable IssueAction a, @Nullable IssueAction b) {
            if (a == null || b == null) {
                return false;
            }
            return Objects.equals(a.getTimePerformed(), b.getTimePerformed());
        }
    }
}

