/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.CommentSearchParameters;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.comment.CommentFieldRenderer;
import com.atlassian.jira.issue.tabpanels.CommentAction;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.issuetabpanel.DefaultPage;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKey;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKeys;
import com.atlassian.jira.plugin.webfragment.conditions.cache.RequestCachingConditionHelper;
import com.atlassian.jira.reactions.CommentReactionsEnabledService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.Window;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class CommentTabPanel
implements PaginatedIssueTabPanel {
    private final CommentManager commentManager;
    private final CommentService commentService;
    private final CommentPermissionManager commentPermissionManager;
    private final CommentReactionsEnabledService commentReactionsEnabledService;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final IssueManager issueManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final CommentFieldRenderer commentFieldRenderer;
    private final CommentPropertyService commentPropertyService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    protected IssueTabPanelModuleDescriptor descriptor;

    public CommentTabPanel(CommentManager commentManager, CommentService commentService, CommentPermissionManager commentPermissionManager, CommentReactionsEnabledService commentReactionsEnabledService, IssueManager issueManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, DateTimeFormatter dateTimeFormatter, CommentFieldRenderer commentFieldRenderer, CommentPropertyService commentPropertyService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.commentManager = commentManager;
        this.commentService = commentService;
        this.commentPermissionManager = commentPermissionManager;
        this.commentReactionsEnabledService = commentReactionsEnabledService;
        this.issueManager = issueManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.commentFieldRenderer = commentFieldRenderer;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.commentPropertyService = commentPropertyService;
    }

    public void init(IssueTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean showPanel(ShowPanelRequest request) {
        return true;
    }

    public Page<IssueAction> getActions(GetActionsRequest request) {
        Page<IssueAction> commentActions = this.getComments(request);
        if (commentActions.getPageContents().isEmpty()) {
            return DefaultPage.only((Collection)Lists.newArrayList((Object[])new IssueAction[]{new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nocomments"))}));
        }
        return commentActions;
    }

    private Page<IssueAction> getComments(final GetActionsRequest request) {
        final Window commentsForIssue = this.commentManager.searchCommentsVisibleForUser(CommentTabPanel.requestToSearchParameters(request));
        return new Page<IssueAction>(){

            public boolean isFirstPage() {
                return !commentsForIssue.hasElementsBefore();
            }

            public boolean isLastPage() {
                return !commentsForIssue.hasElementsAfter();
            }

            public List<IssueAction> getPageContents() {
                return CommentTabPanel.this.convertCommentsToIssueActions(request.loggedInUser(), request.issue(), commentsForIssue.get());
            }
        };
    }

    private static CommentSearchParameters requestToSearchParameters(GetActionsRequest request) {
        CommentSearchParameters.Builder builder = CommentSearchParameters.builder().issue(request.issue()).user(request.loggedInUser());
        if (request.batching().fromDate() != null) {
            if (request.batching().fetchMode() == GetActionsRequest.FetchMode.OLDER_THAN_DATE) {
                builder.searchByDate(request.batching().fromDate(), CommentSearchParameters.SearchDirection.OLDER);
            } else {
                builder.searchByDate(request.batching().fromDate(), CommentSearchParameters.SearchDirection.NEWER);
            }
        } else if (NumberUtils.isCreatable((String)request.getFocusId())) {
            builder.searchByComment(Long.parseLong(request.getFocusId()), CommentSearchParameters.SearchDirection.BOTH);
        } else if (request.batching().fetchMode() == GetActionsRequest.FetchMode.FROM_OLDEST) {
            builder.searchForTheOldestOrNewest(CommentSearchParameters.SearchDirection.OLDER);
        } else {
            builder.searchForTheOldestOrNewest(CommentSearchParameters.SearchDirection.NEWER);
        }
        if (request.isValidShowAllRequest()) {
            builder.noLimit();
        } else {
            builder.limit(request.batching().limit());
        }
        return builder.build();
    }

    private List<IssueAction> convertCommentsToIssueActions(ApplicationUser user, Issue issue, List<Comment> commentsForIssue) {
        ArrayList<IssueAction> commentActions = new ArrayList<IssueAction>();
        CommentEditablePermission permissions = new CommentEditablePermission(this.issueManager, this.commentManager, this.commentPermissionManager, user, issue);
        boolean commentReactionsEnabled = this.isCommentReactionsEnabled();
        boolean canReact = commentReactionsEnabled && RequestCachingConditionHelper.cacheConditionResultInRequest((ConditionCacheKey)ConditionCacheKeys.permission((ProjectPermissionKey)ProjectPermissions.ADD_COMMENTS, (ApplicationUser)user, (Object[])new Object[]{issue}), () -> this.commentService.hasPermissionToCreate(user, issue, (ErrorCollection)new SimpleErrorCollection()));
        for (Comment comment : commentsForIssue) {
            commentActions.add((IssueAction)new CommentAction(this.descriptor, comment, permissions.canEdit(comment), permissions.canDelete(comment), canReact, commentReactionsEnabled, false, this.rendererManager, this.fieldLayoutManager, this.dateTimeFormatter, this.commentFieldRenderer, this.commentPropertyService, this.jiraAuthenticationContext));
        }
        return commentActions;
    }

    public String getPersistentMarkup(GetActionsRequest request) {
        if (this.isCommentReactionsEnabled()) {
            return "<script>resourcePhaseCheckpoint.interaction.then(() => require('wrm/require')('wrc!commentReactions'));</script>";
        }
        return "";
    }

    private boolean isCommentReactionsEnabled() {
        return this.commentReactionsEnabledService.isEnabled() && this.jiraAuthenticationContext.isLoggedInUser();
    }

    private static class CommentEditablePermission {
        private final IssueManager issueManager;
        private final CommentManager commentManager;
        private final CommentPermissionManager commentPermissionManager;
        private final ApplicationUser user;
        boolean issueIsInEditableWorkflow = false;
        boolean canDeleteAllComments = false;
        boolean canDeleteOwnComments = false;
        boolean canEditAllComments = false;
        boolean canEditOwnComments = false;

        public CommentEditablePermission(IssueManager issueManager, CommentManager commentManager, CommentPermissionManager commentPermissionManager, ApplicationUser user, Issue issue) {
            this.issueManager = issueManager;
            this.commentManager = commentManager;
            this.commentPermissionManager = commentPermissionManager;
            this.user = user;
            this.init(issue);
        }

        private void init(Issue issue) {
            this.issueIsInEditableWorkflow = this.issueManager.isEditable(issue);
            this.canDeleteAllComments = this.issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteAllPermission(this.user, issue);
            this.canDeleteOwnComments = this.canDeleteAllComments || this.issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteOwnPermission(this.user, issue);
            this.canEditAllComments = this.issueIsInEditableWorkflow && this.commentPermissionManager.hasEditAllPermission(this.user, issue);
            this.canEditOwnComments = this.canEditAllComments || this.issueIsInEditableWorkflow && this.commentPermissionManager.hasEditOwnPermission(this.user, issue);
        }

        public boolean canDelete(Comment comment) {
            return this.canDeleteAllComments || this.canDeleteOwnComments && this.commentManager.isUserCommentAuthor(this.user, comment);
        }

        public boolean canEdit(Comment comment) {
            return this.canEditAllComments || this.canEditOwnComments && this.commentManager.isUserCommentAuthor(this.user, comment);
        }
    }
}

