/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.util.DatabaseIssuesIterator;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFindOptions;

public class DatabaseIssuesIterable
implements IssuesIterable {
    private final OfBizDelegator delegator;
    private final IssueFactory issueFactory;
    private final EntityCondition condition;
    private final EntityFindOptions findOptions;
    @Nullable
    private final List<String> orderBy;

    public DatabaseIssuesIterable(OfBizDelegator delegator, IssueFactory issueFactory) {
        this(delegator, issueFactory, null, null, null);
    }

    public DatabaseIssuesIterable(OfBizDelegator delegator, IssueFactory issueFactory, @Nullable EntityCondition condition) {
        this(delegator, issueFactory, condition, null, null);
    }

    public DatabaseIssuesIterable(OfBizDelegator delegator, IssueFactory issueFactory, @Nullable EntityCondition condition, @Nullable EntityFindOptions findOptions) {
        this(delegator, issueFactory, condition, null, findOptions);
    }

    public DatabaseIssuesIterable(OfBizDelegator delegator, IssueFactory issueFactory, @Nullable EntityCondition condition, @Nullable List<String> orderBy, @Nullable EntityFindOptions findOptions) {
        this.delegator = (OfBizDelegator)Assertions.notNull((String)(this.getClass().getName() + " needs a not null " + OfBizDelegator.class.getName() + " instance"), (Object)delegator);
        this.issueFactory = (IssueFactory)Assertions.notNull((String)(this.getClass().getName() + " needs a not null " + IssueFactory.class.getName() + " instance"), (Object)issueFactory);
        this.orderBy = orderBy;
        this.condition = condition;
        this.findOptions = findOptions;
    }

    public void foreach(Consumer<Issue> sink) {
        try (DatabaseIssuesIterator iterator = new DatabaseIssuesIterator(this.delegator, this.issueFactory, this.condition, this.orderBy, this.findOptions);){
            while (iterator.hasNext()) {
                Issue next = iterator.next();
                this.spy(next);
                sink.consume((Object)next);
            }
        }
    }

    public int size() {
        return (int)this.delegator.getCount("Issue");
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.getClass().getName() + ": All issues in the database.";
    }

    protected void spy(Issue next) {
    }
}

