/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.FieldValuesChangedEvent;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.InlineIssuePropertySetter;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ComponentLocator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultIssueUpdater
implements IssueUpdater {
    private final OfBizDelegator ofBizDelegator;
    private final IssueEventManager issueEventManager;
    private final IssueEventBundleFactory issueEventBundleFactory;
    private final InlineIssuePropertySetter issuePropertySetter;
    private final ComponentLocator componentLocator;
    private final TxnAwareEventFactory txnAwareEventFactory;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;

    public DefaultIssueUpdater(OfBizDelegator ofBizDelegator, IssueEventManager issueEventManager, IssueEventBundleFactory issueEventBundleFactory, InlineIssuePropertySetter issuePropertySetter, ComponentLocator componentLocator, TxnAwareEventFactory txnAwareEventFactory, EventPublisher eventPublisher, FeatureManager featureManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueEventManager = issueEventManager;
        this.issueEventBundleFactory = issueEventBundleFactory;
        this.issuePropertySetter = issuePropertySetter;
        this.componentLocator = componentLocator;
        this.txnAwareEventFactory = txnAwareEventFactory;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
    }

    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems) {
        this.doUpdate(iub, generateChangeItems, true, Collections.emptyMap());
    }

    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems, Map<String, ModifiedValue> modifiedValues) {
        this.doUpdate(iub, generateChangeItems, true, modifiedValues);
    }

    public void doUpdate(IssueUpdateBean issueUpdateBean, boolean generateChangeItems, boolean updateDate) {
        this.doUpdate(issueUpdateBean, generateChangeItems, updateDate, Collections.emptyMap());
    }

    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems, boolean updateDate, Map<String, ModifiedValue> modifiedValueMap) {
        boolean needsUpdate;
        if (updateDate) {
            iub.getChangedIssue().set("updated", (Object)UtilDateTime.nowTimestamp());
        }
        List<ChangeItemBean> newChangeItems = ChangeLogUtils.generateChangeItems(iub.getOriginalIssue(), iub.getChangedIssue());
        int size = newChangeItems.size() + (iub.getChangeItems() == null ? 0 : iub.getChangeItems().size());
        ArrayList changeItems = Lists.newArrayListWithCapacity((int)size);
        changeItems.addAll(newChangeItems);
        if (iub.getChangeItems() != null) {
            changeItems.addAll(iub.getChangeItems());
        }
        boolean bl = needsUpdate = !changeItems.isEmpty() || iub.getComment() != null || iub.getProperties().size() > 0 || this.doesOriginalCommentExistAndFixIsEnabled(iub);
        if (needsUpdate) {
            this.storeModifiedFields(iub, generateChangeItems, changeItems, modifiedValueMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeModifiedFields(IssueUpdateBean iub, boolean generateChangeItems, List<ChangeItemBean> changeItems, Map<String, ModifiedValue> modifiedValueMap) {
        GenericValue updateIssueGV = new GenericValue(iub.getChangedIssue().getDelegator(), iub.getChangedIssue().getModelEntity());
        updateIssueGV.setPKFields(iub.getChangedIssue().getPrimaryKey().getAllFields());
        for (ChangeItemBean changeItem : changeItems) {
            String fieldName = changeItem.getField();
            if ("issuetype".equals(fieldName)) {
                fieldName = "type";
            }
            if (!updateIssueGV.getModelEntity().isField(fieldName)) continue;
            updateIssueGV.put(fieldName, iub.getChangedIssue().get(fieldName));
        }
        updateIssueGV.put("updated", iub.getChangedIssue().get("updated"));
        Transaction txn = Txn.begin();
        try {
            this.ofBizDelegator.storeAll((List)ImmutableList.of((Object)updateIssueGV));
            Long issueId = iub.getOriginalIssue().getLong("id");
            ApplicationUser user = iub.getApplicationUser();
            GenericValue changeGroup = ChangeLogUtils.createChangeGroup(user, iub.getOriginalIssue(), iub.getChangedIssue(), (Collection<ChangeItemBean>)iub.getChangeItems(), generateChangeItems);
            if (changeGroup != null && iub.getHistoryMetadata() != null) {
                HistoryMetadataManager historyMetadataManager = (HistoryMetadataManager)this.componentLocator.getComponent(HistoryMetadataManager.class);
                historyMetadataManager.saveHistoryMetadata(changeGroup.getLong("id"), user, iub.getHistoryMetadata());
            }
            this.issuePropertySetter.setIssueProperties(user, issueId, iub.getProperties(), false);
            txn.commit();
            if (changeGroup != null) {
                this.txnAwareEventFactory.issueChangedEventOnCommit(issueId, user, iub.getComment(), changeGroup.getLong("id"), iub.isSendMail());
            }
            if ((changeGroup != null || iub.getComment() != null || this.doesOriginalCommentExistAndFixIsEnabled(iub)) && iub.isDispatchEvent()) {
                GenericValue updatedIssue = this.ofBizDelegator.findByPrimaryKey("Issue", updateIssueGV.getLong("id"));
                IssueFactory issueFactory = (IssueFactory)this.componentLocator.getComponent(IssueFactory.class);
                MutableIssue issue = issueFactory.getIssue(updatedIssue);
                this.issueEventManager.dispatchRedundantEvent(iub.getEventTypeId(), (Issue)issue, user, iub.getComment(), iub.getWorklog(), changeGroup, iub.getParams(), iub.isSendMail(), iub.isSubtasksUpdated());
                this.issueEventManager.dispatchEvent(this.issueEventBundleFactory.createIssueUpdateEventBundle((Issue)issue, changeGroup, iub, user));
                this.eventPublisher.publish((Object)new FieldValuesChangedEvent((Issue)issue, modifiedValueMap, false));
            }
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }

    private boolean doesOriginalCommentExistAndFixIsEnabled(IssueUpdateBean iub) {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.FIXED_COMMENT_DELETION_NOTIFICATIONS) && iub.getParams().get("originalcomment") != null;
    }
}

