/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogImpl2;
import com.atlassian.jira.model.querydsl.WorklogDTO;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class WorklogDTOToWorklogConverter {
    private final ProjectRoleManager projectRoleManager;
    private final LoadingCache<Long, Issue> issueCache;

    public WorklogDTOToWorklogConverter(ProjectRoleManager projectRoleManager, final IssueManager issueManager) {
        this.projectRoleManager = projectRoleManager;
        this.issueCache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Issue>(){

            public Issue load(@Nonnull Long key) {
                return issueManager.getIssueObject(key);
            }
        });
    }

    public Worklog convert(WorklogDTO worklogDTO) throws ExecutionException {
        return new WorklogImpl2((Issue)this.issueCache.get((Object)worklogDTO.getIssue()), worklogDTO.getId(), worklogDTO.getAuthor(), worklogDTO.getBody(), worklogDTO.getStartdate(), worklogDTO.getGrouplevel(), worklogDTO.getRolelevel(), worklogDTO.getTimeworked(), worklogDTO.getUpdateauthor(), worklogDTO.getCreated(), worklogDTO.getUpdated(), worklogDTO.getRolelevel() != null ? this.projectRoleManager.getProjectRole(worklogDTO.getRolelevel()) : null);
    }
}

