/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand;

import com.atlassian.jira.bc.issue.search.QueryCache;
import com.atlassian.jira.jql.operand.EmptyOperandHandler;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.MultiValueOperandHandler;
import com.atlassian.jira.jql.operand.OperandHandler;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operand.SingleValueOperandHandler;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.plugin.jql.function.ClauseSanitisingJqlFunction;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public final class DefaultJqlOperandResolver
implements JqlOperandResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultJqlOperandResolver.class);
    private final JqlFunctionHandlerRegistry registry;
    private final I18nHelper.BeanFactory factory;
    private final OperandHandler<EmptyOperand> emptyHandler;
    private final OperandHandler<SingleValueOperand> singleHandler;
    private final OperandHandler<MultiValueOperand> multiHandler;
    private final QueryCache queryCache;

    public DefaultJqlOperandResolver(JqlFunctionHandlerRegistry registry, I18nHelper.BeanFactory factory, QueryCache queryCache) {
        this.factory = (I18nHelper.BeanFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.registry = (JqlFunctionHandlerRegistry)Assertions.notNull((String)"registry", (Object)registry);
        this.queryCache = (QueryCache)Assertions.notNull((String)"queryCache", (Object)queryCache);
        this.emptyHandler = new EmptyOperandHandler();
        this.singleHandler = new SingleValueOperandHandler();
        this.multiHandler = new MultiValueOperandHandler(this);
    }

    DefaultJqlOperandResolver(JqlFunctionHandlerRegistry registry, I18nHelper.BeanFactory factory, OperandHandler<EmptyOperand> emptyHandler, OperandHandler<SingleValueOperand> singleHandler, OperandHandler<MultiValueOperand> multiHandler, QueryCache queryCache) {
        this.registry = (JqlFunctionHandlerRegistry)Assertions.notNull((String)"registry", (Object)registry);
        this.factory = (I18nHelper.BeanFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.emptyHandler = (OperandHandler)Assertions.notNull((String)"emptyHandler", emptyHandler);
        this.singleHandler = (OperandHandler)Assertions.notNull((String)"singleHandler", singleHandler);
        this.multiHandler = (OperandHandler)Assertions.notNull((String)"multiHandler", multiHandler);
        this.queryCache = (QueryCache)Assertions.notNull((String)"queryCache", (Object)queryCache);
    }

    public List<QueryLiteral> getValues(ApplicationUser searcher, Operand operand, TerminalClause terminalClause) {
        return this.getValues((QueryCreationContext)new QueryCreationContextImpl(searcher), operand, terminalClause);
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, Operand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"operand", (Object)operand);
        List<Object> values = this.getValuesFromCache(queryCreationContext, operand, terminalClause);
        if (values == null) {
            if (operand instanceof EmptyOperand) {
                values = this.emptyHandler.getValues(queryCreationContext, (EmptyOperand)operand, terminalClause);
            } else if (operand instanceof SingleValueOperand) {
                values = this.singleHandler.getValues(queryCreationContext, (SingleValueOperand)operand, terminalClause);
            } else if (operand instanceof MultiValueOperand) {
                try (Ticker ignored = Timers.start((String)"DefaultJqlOperandResolver.getValues() - multivalue");){
                    values = this.multiHandler.getValues(queryCreationContext, (MultiValueOperand)operand, terminalClause);
                }
            } else if (operand instanceof FunctionOperand) {
                try (Ticker ignored = Timers.start((String)"DefaultJqlOperandResolver.getValues() - function");){
                    FunctionOperand funcOperand = (FunctionOperand)operand;
                    FunctionOperandHandler handler = this.registry.getOperandHandler(funcOperand);
                    values = handler != null ? handler.getValues(queryCreationContext, funcOperand, terminalClause) : Collections.emptyList();
                }
            } else {
                log.debug(String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
            }
            this.putValuesInCache(queryCreationContext, operand, terminalClause, values);
        }
        return values;
    }

    public MessageSet validate(ApplicationUser user, Operand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"operand", (Object)operand);
        if (operand instanceof EmptyOperand) {
            return this.emptyHandler.validate(user, (EmptyOperand)operand, terminalClause);
        }
        if (operand instanceof SingleValueOperand) {
            return this.singleHandler.validate(user, (SingleValueOperand)operand, terminalClause);
        }
        if (operand instanceof MultiValueOperand) {
            return this.multiHandler.validate(user, (MultiValueOperand)operand, terminalClause);
        }
        if (operand instanceof FunctionOperand) {
            FunctionOperand funcOperand = (FunctionOperand)operand;
            FunctionOperandHandler handler = this.registry.getOperandHandler(funcOperand);
            if (handler != null) {
                return handler.validate(user, funcOperand, terminalClause);
            }
            MessageSetImpl messageSet = new MessageSetImpl();
            messageSet.addErrorMessage(this.getI18n(user).getText("jira.jql.operand.illegal.function", operand.getDisplayString()));
            return messageSet;
        }
        log.debug(String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(this.getI18n(user).getText("jira.jql.operand.illegal.operand", operand.getDisplayString()));
        return messageSet;
    }

    public MessageSet validate(ApplicationUser searcher, Operand operand, WasClause clause) {
        return new MessageSetImpl();
    }

    public FunctionOperand sanitiseFunctionOperand(final ApplicationUser searcher, final FunctionOperand funcOperand) {
        JqlFunction jqlFunction;
        FunctionOperandHandler funcHandler = this.registry.getOperandHandler(funcOperand);
        if (funcHandler != null && (jqlFunction = funcHandler.getJqlFunction()) instanceof ClauseSanitisingJqlFunction) {
            return (FunctionOperand)SafePluginPointAccess.call((Callable)new Callable<FunctionOperand>(){

                @Override
                public FunctionOperand call() throws Exception {
                    return ((ClauseSanitisingJqlFunction)jqlFunction).sanitiseOperand(searcher, funcOperand);
                }
            }).getOrElse((Object)funcOperand);
        }
        return funcOperand;
    }

    public QueryLiteral getSingleValue(ApplicationUser user, Operand operand, TerminalClause clause) {
        List<QueryLiteral> list = this.getValues(user, operand, clause);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("Found more than one value in operand '" + operand + "'; values were: " + list);
        }
        return list.get(0);
    }

    public boolean isEmptyOperand(Operand operand) {
        OperandHandler<?> operandHandler = this.getOperandHandler(operand);
        return operandHandler != null && operandHandler.isEmpty();
    }

    public boolean isFunctionOperand(Operand operand) {
        OperandHandler<?> handler = this.getOperandHandler(operand);
        return handler != null && handler.isFunction();
    }

    public boolean isListOperand(Operand operand) {
        OperandHandler<?> handler = this.getOperandHandler(operand);
        return handler != null && handler.isList();
    }

    public boolean isValidOperand(Operand operand) {
        return this.getOperandHandler(operand) != null;
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.factory.getInstance(user);
    }

    private OperandHandler<?> getOperandHandler(Operand operand) {
        Assertions.notNull((String)"operand", (Object)operand);
        if (operand instanceof EmptyOperand) {
            return this.emptyHandler;
        }
        if (operand instanceof SingleValueOperand) {
            return this.singleHandler;
        }
        if (operand instanceof MultiValueOperand) {
            return this.multiHandler;
        }
        if (operand instanceof FunctionOperand) {
            FunctionOperand funcOperand = (FunctionOperand)operand;
            return this.registry.getOperandHandler(funcOperand);
        }
        log.debug(String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
        return null;
    }

    private List<QueryLiteral> getValuesFromCache(QueryCreationContext ctx, Operand operand, TerminalClause jqlClause) {
        return this.queryCache.getValues(ctx, operand, jqlClause);
    }

    private void putValuesInCache(QueryCreationContext ctx, Operand operand, TerminalClause jqlClause, List<QueryLiteral> values) {
        if (values != null) {
            this.queryCache.setValues(ctx, operand, jqlClause, values);
        }
    }
}

