/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.StatusCategoryResolver;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class StatusCategoryClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(StatusCategoryClauseQueryFactory.class);
    private final StatusCategoryResolver statusCategoryResolver;
    private final StatusManager statusManager;
    private final JqlOperandResolver jqlOperandResolver;

    public StatusCategoryClauseQueryFactory(StatusManager statusManager, JqlOperandResolver jqlOperandResolver, StatusCategoryResolver statusCategoryResolver) {
        this.statusCategoryResolver = (StatusCategoryResolver)Assertions.notNull((String)"statusCategoryResolver", (Object)statusCategoryResolver);
        this.statusManager = (StatusManager)Assertions.notNull((String)"statusManager", (Object)statusManager);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            log.debug(String.format("Operator '%s' is not supported.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        Set<String> statusIds = this.getStatusIdsFromClause(queryCreationContext, terminalClause);
        return new QueryFactoryResult(this.createQueryForValues(statusIds), this.isNegationOperator(operator));
    }

    private Set<String> getStatusIdsFromClause(QueryCreationContext queryCreationContext, TerminalClause clause) {
        LinkedHashSet<QueryLiteral> rawValues;
        List list = this.jqlOperandResolver.getValues(queryCreationContext, clause.getOperand(), clause);
        LinkedHashSet<Object> linkedHashSet = rawValues = list != null ? new LinkedHashSet<QueryLiteral>(list) : new LinkedHashSet();
        if (this.isNegationOperator(clause.getOperator())) {
            rawValues.add(new QueryLiteral());
        }
        Set<StatusCategory> categories = this.statusCategoryResolver.getStatusCategories(rawValues);
        HashSet<String> statusIds = new HashSet<String>();
        for (Status status : this.statusManager.getStatuses()) {
            if (!categories.contains(status.getStatusCategory())) continue;
            statusIds.add(status.getId());
        }
        return statusIds;
    }

    private Query createQueryForValues(Set<String> values) {
        if (values.size() == 1) {
            String value = values.iterator().next();
            return this.getTermQuery(value);
        }
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        for (String value : values) {
            combined.add((Query)this.getTermQuery(value), BooleanClause.Occur.SHOULD);
        }
        return combined.build();
    }

    private TermQuery getTermQuery(String value) {
        return new TermQuery(new Term(SystemSearchConstants.forStatusCategory().getIndexField(), value));
    }

    private boolean isNegationOperator(Operator operator) {
        return operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }
}

